/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation defines a class that will export its functionality as a Mule Connector.
 * <p/>
 * There are a few restrictions as to which types as valid for this annotation:
 * <ol>
 *     <li>It cannot be an interface</li>
 *     <br/>
 *     <li>It must be public</li>
 *     <br/>
 *     <li>It cannot have a typed parameter (no generics)</li>
 * </ol>
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Connector {
    /**
     * The name of the connector.
     */
    String name();

    /**
     * The schema version of the connector. Defaults to 1.0.
     */
    String schemaVersion() default DEFAULT_VERSION;

    /**
     * Namespace of the connector
     */
    String namespace() default "";

    /**
     * Location URI for the schema
     */
    String schemaLocation() default "";

    /**
     * Minimum Mule version required
     */
    String minMuleVersion() default "3.5.0";

    /**
     * Provides a friendly name for the module.
     */
    String friendlyName();

    /**
     * Name of the configuration element
     */
    String configElementName() default "config";

    /**
     * Short description about the annotated module.
     */
    String description() default "";

    String DEFAULT_VERSION = "1.0";

    /**
     * Whether connectivity testing is enabled or not in this connector
     */
    ConnectivityTesting connectivityTesting() default ConnectivityTesting.ON;

    /**
     * Whether metadata is enable or not in this connector
     */

    MetaDataSwitch metaData() default MetaDataSwitch.ON;
}