package org.mule.api.annotations;

import java.lang.annotation.*;

/**
 * Defines the field to be injected as connection strategy into a {@link Connector}. It can be either a concrete class,
 * an abstract class or an interface. The latter case is useful when defining several ways to connect to a service.
 *
 * The most important assumption for a ConnectionStrategy is that when an operation of your connector is going to be executed
 * the strategy will be connected first.
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Config {
}
