package org.mule.api.annotations.lifecycle;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This is a lifecycle annotation, since the handler will be injected in the common cycle when an exception occurs.
 * When an exception occurs in the method or module annotated with @{@link OnException} the handler declared in this
 * annotation will be called immediately, passing to the @{@link org.mule.api.annotations.Handle} the thrown exception
 * The scope of this annotations corresponds to a module or method context.
 * When used in a method, this will handle exceptions occurred in this
 * processor only. If a module level handler is also declared, it will be the common handler for all the processors.
 * No fallback from the specific to the common handlers exists, the method level handler will override the
 * module level one.
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.SOURCE)
public @interface OnException {

    Class handler();
}
