/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation defines a class that will export its functionality as a Mule module.
 * <p/>
 * There are a few restrictions as to which types as valid for this annotation:
 * <ol>
 *     <li>It cannot be an interface</li>
 *     <br/>
 *     <li>It must be public</li>
 *     <br/>
 *     <li>It cannot have a typed parameter (no generics)</li>
 * </ol>
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
@Documented
@Deprecated
public @interface Module {
    /**
     * The name of the module.
     */
    String name();

    /**
     * The version of the module. Defaults to 1.0.
     */
    String schemaVersion() default AnnotationsConstants.DEFAULT_SCHEMA_VERSION;

    /**
     * Namespace of the module
     */
    String namespace() default "";

    /**
     * Location URI for the schema
     */
    String schemaLocation() default "";

    /**
     * Defined the module itself as being poolable
     */
    boolean poolable() default false;

    /**
     * Minimum Mule version required
     */
    String minMuleVersion() default AnnotationsConstants.MIN_MULE_VERSION;

    /**
     * Provides a friendly name for the module.
     */
    String friendlyName();

    /**
     * Name of the configuration element
     */
    @Deprecated
    String configElementName() default AnnotationsConstants.DEPRECATED_CONFIG_ELEMENT_NAME;

    /**
     * Short description about the annotated module.
     */
    String description() default "";

    /**
     * This attribute is deprecated, use {@link org.mule.api.annotations.TestConnectivity} annotation instead
     */
    @Deprecated
    ConnectivityTesting connectivityTesting() default ConnectivityTesting._DEPRECATED;

    /**
     * Whether metadata is enable or not in this connector
     */
    @Deprecated
    MetaDataSwitch metaData() default MetaDataSwitch._DEPRECATED;

}