package org.mule.api.annotations.components;

import org.mule.api.annotations.AnnotationsConstants;

import java.lang.annotation.*;

/**
 * This annotation is used to define a WSDL type of strategy, that will need to be complemented with {@link org.mule.api.annotations.ws.WsdlServiceRetriever}
 * and {@link org.mule.api.annotations.ws.WsdlServiceEndpoint}.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface WsdlProvider {
    /**
     * Name of the configuration element
     */
    String configElementName() default AnnotationsConstants.CONFIG_ELEMENT_NAME;

    /**
     * Provides a friendly name for the strategy.
     */
    String friendlyName();
}
