/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.licensing;

import org.mule.devkit.internal.lic.model.Entitlement;

import java.lang.annotation.*;

/**
 * Checks if the Module/Processor requires an Enterprise license with a particular entitlement.
 */
@Target({ElementType.TYPE})
@Documented
@Retention(RetentionPolicy.SOURCE)
public @interface RequiresEntitlement {
 
    String name() default "";
    
    String description() default "";

    String provider() default Entitlement.DEFAULT_PROVIDER;
}
