/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.api.annotations.rest;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Allows you to dynamically generate URIs by inserting parameters which are annotated with the
 * {@link RestUriParam} annotation.
 *
 * You can use the {@link RestUriParam}  annotation, as well as other related annotations,
 * on  @{@link org.mule.api.annotations.Processor}  method arguments or @Configurable  fields of the connector.
 *
 * When generating the request call, DevKit includes a non-annotated argument
 * and an argument annotated with {@link org.mule.api.annotations.param.Payload} as the body of the call.
 *
 * When applying annotations to {@link org.mule.api.annotations.Processor} methods, specify a placeholder
 * in the URI by surrounding the placeholder with curly braces, for example  {type}.
 */
@Target(value = {ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RestUriParam {
    String value();

    String separatedBy() default "";

    boolean ignoreIfEmpty() default false;
}
