/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

import java.lang.annotation.*;

/**
 * Defines the field to be injected as connection strategy into a {@link Connector}. It can be either a concrete class,
 * an abstract class or an interface. The latter case is useful when defining several ways to connect to a service.
 *
 * The most important assumption for a ConnectionStrategy is that when an operation of your connector is going to be executed
 * the strategy will be connected first.
 *
 * @see org.mule.api.annotations.components.ConnectionManagement
 * @see org.mule.api.annotations.oauth.OAuth2
 * @see org.mule.api.annotations.components.Configuration
 * @see org.mule.api.annotations.components.HttpBasicAuth
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.SOURCE)
@Documented
public @interface Config {

}
