/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation indicates which method in the {@link org.mule.api.annotations.components.Handler} class
 * should be called when the component is invoked
 * The @Handle method can return two results:
 *  RECONNECT - Retry the operation if the {@link Processor} has {@link ReconnectOn}, and the {@link Handle} throws an exception of that kind.
 *  FAIL - Fail the operation by throwing an exception that does not belongs to the {@link ReconnectOn}, or the processors don't support reconnection.
 * Note: If a method annotated with {@link Handle} does not throw an exception during its execution, the original exception are re-thrown.
 *
 * The {@link Handle} method :
 * <ol>
 * <li>Must receive an Exception as parameter
 * <li>Must return void
 * <li>Must be declared with throws Exception
 * </ol>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.SOURCE)
public @interface Handle {
}
