/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */


package org.mule.api.annotations.rest;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies URI query parameters, which are appended to the path of the URI after a ? or & symbol.
 * You can apply this annotation to {@link org.mule.api.annotations.Processor} method arguments or to connector fields marked {@link org.mule.api.annotations.Configurable}.
 * This enables you to use dynamically-generated arguments as query parameters.
 *
 * Required argument:  String representation of the name of the parameter to append.
 *
 * @see RestCall
 */
@Target(value = {ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Deprecated
public @interface RestQueryParam {
    String value();

    String separatedBy() default "";

    boolean ignoreIfEmpty() default false;
}
