/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations.param;

/**
 * It defines the target of a dynamic parameter when annotated with {@link org.mule.api.annotations.param.MetaDataKeyParam}
 */
public enum MetaDataKeyParamAffectsType {
    /*
    * Makes the input dynamic (independently of its type), iff has a @Optional @Default("#[payload]")
    * */
    INPUT,
    /*
    * Makes the output dynamic (independently of its type), iff it's not void
    * */
    OUTPUT,
    /*
    * Makes the input and output dynamic (independently of their types), iff the input has @Optional @Default("#[payload]") and the output it's not void
    * */
    BOTH,
    /*
    * Makes the input and/or output dynamic iff, the input and/or output are are Map<String,Object>
    *     (previous and default behavior)
    * */
    AUTO
}
