/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.api.annotations;

/**
 * Helper class to point to the current mule version.
 */
public interface AnnotationsConstants {
    /**
     * The {@link #MIN_MULE_VERSION} variable should target the current mule version DevKit is working on.
     */
    String MIN_MULE_VERSION = "3.5.0";

    /**
     * The schema version of the {@link @org.mule.api.annotations.Connector} or {@link @org.mule.api.annotations.Module}.
     * Defaults to 1.0.
     */
    String DEFAULT_SCHEMA_VERSION = "1.0";

    /**
     * Name of the configuration element
     */
    String CONFIG_ELEMENT_NAME = "config";

    /**
     * Name of the Connector/Module Deprecated configuration element.
     */
    String DEPRECATED_CONFIG_ELEMENT_NAME = "config";
}
