/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.apidoc.misc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.model.apidoc.misc.TypeLinkCreator;

public class JavadocFormater {
    private static Pattern tagPattern = Pattern.compile("\\{@.*?}");
    private String formated = "";

    public JavadocFormater(String javadoc) {
        if (!StringUtils.isBlank((String)javadoc)) {
            this.formated = StringUtils.chomp((String)javadoc);
            this.formated = this.parseTags(this.formated);
        }
    }

    public String format() {
        return this.removeBlankLines(this.formated);
    }

    private String parseTags(String description) {
        Matcher matcher = tagPattern.matcher(description);
        while (matcher.find()) {
            String match = matcher.group();
            String tag = match.substring(1, match.indexOf(" "));
            String content = match.substring(match.indexOf(" ")).replace("}", "").trim();
            switch (tag) {
                case "@link": {
                    content = this.parseAtLink(content);
                    break;
                }
                case "@see": {
                    content = this.parseAtSee(content);
                    break;
                }
            }
            description = description.replace(match, content);
        }
        return description;
    }

    private String parseAtLink(String content) {
        return TypeLinkCreator.getInstance().create(content);
    }

    private String parseAtSee(String content) {
        if (content.startsWith("http") || content.startsWith("www.")) {
            String title = content.substring(content.lastIndexOf("/") + 1);
            title = title.contains(".") ? title.substring(0, title.indexOf(".")) : title;
            content = "<a href=\"" + content + "\"> " + title + " </a>";
        }
        return content;
    }

    private String removeBlankLines(String s) {
        return s.replaceAll("(?m)^[ \t]*\r?\n", "").trim();
    }
}

