/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc.misc;

import org.apache.commons.lang.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavadocFormater {

    private static Pattern tagPattern = Pattern.compile("\\{@.*?}");
    private String formated = "";

    public JavadocFormater(String javadoc) {
        if (!StringUtils.isBlank(javadoc)) {
            formated = StringUtils.chomp(javadoc);
            formated = parseTags(formated);
        }
    }

    public String format(){
        return removeBlankLines(formated);
    }

    // Remove tags such as {@link }, {@see }, etc, and parses to the correct output
    private String parseTags(String description) {
        Matcher matcher = tagPattern.matcher(description);
        while(matcher.find()) {
            String match = matcher.group();
            String tag = match.substring(1, match.indexOf(" "));
            String content = match.substring(match.indexOf(" ")).replace("}", "").trim();
            switch (tag) {
                case "@link": content = parseAtLink(content); break;
                case "@see": content = parseAtSee(content); break;
                default: break;
            }
            description = description.replace(match, content);
        }
        return description;
    }

    private String parseAtLink(String content) {
        return TypeLinkCreator.getInstance().create(content);
    }

    private String parseAtSee(String content) {
        if(content.startsWith("http") || content.startsWith("www.")) {
            String title = content.substring(content.lastIndexOf("/") + 1);
            title = title.contains(".")? title.substring(0, title.indexOf(".")) : title;
            content = "<a href=\"" + content + "\"> " + title +" </a>";
        }
        return content;
    }

    private String removeBlankLines(String s) {
        return s.replaceAll("(?m)^[ \t]*\r?\n", "").trim();
    }
}
