/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.apidoc.misc;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TypeLinkCreator {
    private static TypeLinkCreator typeLinkCreator;
    private Map<String, String> packageUrl = new HashMap<String, String>();

    private TypeLinkCreator() {
    }

    public static TypeLinkCreator getInstance() {
        if (typeLinkCreator == null) {
            typeLinkCreator = new TypeLinkCreator();
        }
        return typeLinkCreator;
    }

    public String create(String fullQualifiedName) {
        List<Object> generics;
        String pattern;
        if (fullQualifiedName.contains("<")) {
            pattern = fullQualifiedName.substring(0, fullQualifiedName.indexOf("<"));
            generics = this.genericsFromFullQualifiedName(fullQualifiedName);
        } else {
            pattern = fullQualifiedName;
            generics = new ArrayList();
        }
        String baseName = pattern.substring(pattern.lastIndexOf(".") + 1);
        StringBuilder builder = new StringBuilder();
        Optional<String> key = this.packageKeyMatch(pattern);
        if (key.isPresent()) {
            String baseUrl = this.packageUrl.get(key.get());
            String url = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
            builder.append("<a href=\"" + url + pattern.replace(".", "/") + ".html\">" + baseName + "</a>");
        } else {
            builder.append(baseName);
        }
        if (!generics.isEmpty()) {
            builder.append("<");
            Iterator<Object> iterator = generics.iterator();
            builder.append(this.create((String)iterator.next()));
            while (iterator.hasNext()) {
                builder.append(",").append(this.create((String)iterator.next()));
            }
            builder.append(">");
        }
        return builder.toString();
    }

    private List<String> genericsFromFullQualifiedName(String fullQualifiedName) {
        ArrayList<String> generics = new ArrayList<String>();
        if (fullQualifiedName.contains("<")) {
            String genericTypes = fullQualifiedName.substring(fullQualifiedName.indexOf("<") + 1, fullQualifiedName.lastIndexOf(">"));
            generics.addAll(this.parseTypes(genericTypes));
        }
        return generics;
    }

    private List<String> parseTypes(String genericTypes) {
        ArrayList<String> types = new ArrayList<String>();
        int level = 0;
        int begin = 0;
        char[] chars = genericTypes.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '<') {
                ++level;
            }
            if (c == '>') {
                --level;
            }
            if (c != ',' || level != 0) continue;
            types.add(genericTypes.substring(begin, i));
            begin = i + 1;
        }
        types.add(genericTypes.substring(begin, chars.length));
        return types;
    }

    private Optional<String> packageKeyMatch(String fullQualifiedName) {
        for (String key : this.packageUrl.keySet()) {
            if (!fullQualifiedName.startsWith(key)) continue;
            return Optional.fromNullable((Object)key);
        }
        return Optional.absent();
    }

    public void putEntriesFromJavadocTag(String javadocUrls) {
        if (StringUtils.isNotBlank((String)javadocUrls)) {
            for (String s : javadocUrls.split(";")) {
                String _package = s.substring(0, s.indexOf("["));
                String url = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
                this.packageUrl.put(_package, url);
            }
        }
    }

    public void putPackageUrl(String _package, String url) {
        this.packageUrl.put(_package, url);
    }
}

