/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.apidoc.builder;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.mule.devkit.model.apidoc.ModuleModel;
import org.mule.devkit.model.apidoc.Variable;
import org.mule.devkit.model.apidoc.config.Config;
import org.mule.devkit.model.apidoc.desarializer.ConfigSerializer;
import org.mule.devkit.model.apidoc.misc.TypeLinkCreator;
import org.mule.devkit.model.apidoc.operation.FilterOperation;
import org.mule.devkit.model.apidoc.operation.ProcessorOperation;
import org.mule.devkit.model.apidoc.operation.SourceOperation;
import org.mule.devkit.model.apidoc.operation.TransformerOperation;

public class ModuleBuilder {
    ModuleModel module = new ModuleModel();

    private ModuleBuilder() {
    }

    public ModuleBuilder description(String description) {
        this.build().description(description);
        return this;
    }

    public ModuleBuilder friendlyName(String friendlyName) {
        this.build().friendlyName(friendlyName);
        return this;
    }

    public ModuleBuilder javaName(String name) {
        this.build().javaName(name);
        return this;
    }

    public ModuleBuilder attributes(List<Variable> attributes) {
        this.module.attributes(attributes);
        return this;
    }

    public ModuleBuilder configs(List<Config> configs) {
        this.module.configs(configs);
        return this;
    }

    public ModuleBuilder minMuleVersion(String minMuleVersion) {
        this.module.minMuleVersion(minMuleVersion);
        return this;
    }

    public ModuleBuilder addProcessors(List<ProcessorOperation> operations) {
        this.module.processors(operations);
        return this;
    }

    public ModuleBuilder addTransformers(List<TransformerOperation> operations) {
        this.module.transformers(operations);
        return this;
    }

    public ModuleBuilder addFilters(List<FilterOperation> operations) {
        this.module.filters(operations);
        return this;
    }

    public ModuleBuilder addSources(List<SourceOperation> operations) {
        this.module.sources(operations);
        return this;
    }

    public ModuleBuilder xsdName(String xsdName) {
        this.module.xsdName(xsdName);
        return this;
    }

    public ModuleBuilder requiresEntitlement(Boolean value) {
        this.module.requiresEntitlement(value);
        return this;
    }

    public ModuleBuilder requiresEnterpriseLicense(Boolean value) {
        this.module.requiresEnterpriseLicense(value);
        return this;
    }

    public ModuleBuilder addJavadocUrls(String javadocUrlTag) {
        TypeLinkCreator.getInstance().putEntriesFromJavadocTag(javadocUrlTag);
        return this;
    }

    public ModuleBuilder addJavadocUrl(String _package, String url) {
        TypeLinkCreator.getInstance().putPackageUrl(_package, url);
        return this;
    }

    public static ModuleModel fromJson(String filePath) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(filePath, new String[0]));
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Config.class, (Object)new ConfigSerializer());
        return (ModuleModel)gsonBuilder.create().fromJson(new String(encoded), ModuleModel.class);
    }

    public static ModuleModel fromJson(File file) throws IOException {
        return ModuleBuilder.fromJson(file.getAbsolutePath());
    }

    public static ModuleBuilder getInstance() {
        return new ModuleBuilder();
    }

    public ModuleModel build() {
        return this.module;
    }
}

