/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc;

import org.apache.commons.lang.StringUtils;
import org.mule.devkit.model.apidoc.misc.JavadocFormater;

/**
 * Represents an element in the DevKit model,
 * This includes Configurable Fields, Configs,
 * all the Operation Types and Modules and Connectors itself
 */
public abstract class AbstractElement implements Element {

    /**
     * The element name in the code itself
     */
    protected String javaName;

    /**
     * Some elements have a friendlyName attribute
     * or are annotated with the FriendlyName annotation.
     * If none a friendlyName is generated from the javaName
     */
    protected String friendlyName;

    /**
     * The description of the element.
     * is taken from the associated element javadoc
     */
    protected String description;

    /**
     * The element xsd name .
     * is taken from the name attribute, or auto-generated if not specified
     */
    protected String xsdName;

    @Override
    public String description() {
        return new JavadocFormater(description).format();
    }

    @Override
    public String friendlyName() {
        return friendlyName;
    }

    @Override
    public String javaName() {
        return setEmptyForNull(javaName);
    }

    @Override
    public String xsdName(){
        return xsdName;
    }

    @Override
    public void description(String description) {
        this.description = description;
    }

    @Override
    public void friendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Override
    public void javaName(String javaName) {
        this.javaName = javaName;
    }

    @Override
    public void xsdName(String xsdName){
        this.xsdName = xsdName;
    }

    protected String setEmptyForNull(String value){
        return StringUtils.isBlank(value)? "" : value;
    }




}
