/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code.fmt;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mule.devkit.model.code.ResourceFile;

public final class StaticFile
extends ResourceFile {
    private final ClassLoader classLoader;
    private final String resourceName;
    private final boolean isResource;

    public StaticFile(String _resourceName) {
        this(_resourceName, !_resourceName.endsWith(".java"));
    }

    public StaticFile(String _resourceName, boolean isResource) {
        this(StaticFile.class.getClassLoader(), _resourceName, isResource);
    }

    public StaticFile(ClassLoader _classLoader, String _resourceName, boolean isResource) {
        super(_resourceName.substring(_resourceName.lastIndexOf(47) + 1));
        this.classLoader = _classLoader;
        this.resourceName = _resourceName;
        this.isResource = isResource;
    }

    protected boolean isResource() {
        return this.isResource;
    }

    protected void build(OutputStream os) throws IOException {
        int sz;
        DataInputStream dis = new DataInputStream(this.classLoader.getResourceAsStream(this.resourceName));
        byte[] buf = new byte[256];
        while ((sz = dis.read(buf)) > 0) {
            os.write(buf, 0, sz);
        }
        dis.close();
    }
}

