/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;

public class GeneratedConditional
implements Statement {
    private GeneratedExpression test = null;
    private GeneratedBlock _then = new GeneratedBlock();
    private GeneratedBlock _else = null;

    GeneratedConditional(GeneratedExpression test) {
        this.test = test;
    }

    public GeneratedBlock _then() {
        return this._then;
    }

    public GeneratedBlock _else() {
        if (this._else == null) {
            this._else = new GeneratedBlock();
        }
        return this._else;
    }

    public GeneratedConditional _elseif(GeneratedExpression boolExp) {
        return this._else()._if(boolExp);
    }

    public void state(Formatter f) {
        if (this.test == ExpressionFactory.TRUE) {
            this._then.generateBody(f);
            return;
        }
        if (this.test == ExpressionFactory.FALSE) {
            this._else.generateBody(f);
            return;
        }
        if (Op.hasTopOp(this.test)) {
            f.p("if ").g(this.test);
        } else {
            f.p("if (").g(this.test).p(')');
        }
        f.g(this._then);
        if (this._else != null) {
            f.p("else").g(this._else);
        }
        f.nl();
    }
}

