/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;

public final class GeneratedForEach
implements Statement {
    private final Type type;
    private final String var;
    private GeneratedBlock body = null;
    private final GeneratedExpression collection;
    private final GeneratedVariable loopVar;

    public GeneratedForEach(Type vartype, String variable, GeneratedExpression collection) {
        this.type = vartype;
        this.var = variable;
        this.collection = collection;
        this.loopVar = new GeneratedVariable(Modifiers.forVar(0), this.type, this.var, collection);
    }

    public GeneratedVariable var() {
        return this.loopVar;
    }

    public GeneratedBlock body() {
        if (this.body == null) {
            this.body = new GeneratedBlock();
        }
        return this.body;
    }

    public void state(Formatter f) {
        f.p("for (");
        f.g(this.type).id(this.var).p(": ").g(this.collection);
        f.p(')');
        if (this.body != null) {
            f.g(this.body).nl();
        } else {
            f.p(';').nl();
        }
    }
}

