/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2011 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.mule.devkit.model.code;

import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

import org.apache.commons.lang.StringUtils;

/**
 * A generated Java class/interface/enum/....
 * <p/>
 * <p/>
 * This class models a declaration, and since a declaration can be always
 * used as a reference, it inherits {@link TypeReference}.
 * <p/>
 * <h2>Where to go from here?</h2>
 * <p/>
 * You'd want to generate fields and methods on a class.
 * See {@link #method(int, Type, String)} and {@link #field(int, Type, String)}.
 */
public class GeneratedClass
        extends TypeReference
        implements Declaration, ClassContainer, Generifiable, Annotable, Documentable {

    public static final String MULE_CONTEXT_JAVADOC = "Mule Context";
    public static final String MULE_CONTEXT_FIELD_NAME = "muleContext";
    public static final String FLOW_CONSTRUCT_JAVADOC = "Flow Construct";
    public static final String FLOW_CONSTRUCT_FIELD_NAME = "flowConstruct";
    /**
     * Name of this class. Null if anonymous.
     */
    private String name;

    /**
     * Modifiers for the class declaration
     */
    private Modifiers mods;

    /**
     * Name of the super class of this class.
     */
    private TypeReference superClass;

    /**
     * List of interfaces that this class implements
     */
    private final Set<TypeReference> interfaces = new TreeSet<TypeReference>();

    /**
     * Fields keyed by their names.
     */
    /*package*/ final Map<String, GeneratedField> fields = new LinkedHashMap<String, GeneratedField>();

    /**
     * Static initializer, if this class has one
     */
    private GeneratedBlock init;

    /**
     * class javadoc
     */
    private GeneratedJavaDocComment jdoc;

    /**
     * Set of constructors for this class, if any
     */
    private final List<GeneratedMethod> constructors = new ArrayList<GeneratedMethod>();

    /**
     * Set of methods that are members of this class
     */
    private final List<GeneratedMethod> methods = new ArrayList<GeneratedMethod>();

    /**
     * Nested classes as a map from name to DefinedClass.
     * The name is all capitalized in a case sensitive file system
     * ({@link CodeModel#isCaseSensitiveFileSystem}) to avoid conflicts.
     * <p/>
     * Lazily created to save footprint.
     *
     * @see #getClasses()
     */
    private Map<String, GeneratedClass> classes;


    /**
     * Flag that controls whether this class should be really generated or not.
     * <p/>
     * Sometimes it is useful to generate code that refers to class X,
     * without actually generating the code of X.
     * This flag is used to surpress X.java file in the output.
     */
    private boolean hideFile;

    /**
     * Client-app spcific metadata associated with this user-created class.
     */
    public Object metadata;

    /**
     * String that will be put directly inside the generated code.
     * Can be null.
     */
    private String directBlock;

    /**
     * If this is a package-member class, this is {@link GeneratedPackage}.
     * If this is a nested class, this is {@link GeneratedClass}.
     * If this is an anonymous class, this constructor shouldn't be used.
     */
    private ClassContainer outer;


    /**
     * Default value is class or interface
     * or annotationTypeDeclaration
     * or enum
     */
    private final GeneratedClassType classType;

    /** List containing the enum value declarations
     *
     */
//    private List enumValues = new ArrayList();

    /**
     * Set of enum constants that are keyed by names.
     * In Java, enum constant order is actually significant,
     * because of order ID they get. So let's preserve the order.
     */
    private final Map<String, EnumConstant> enumConstantsByName = new LinkedHashMap<String, EnumConstant>();

    /**
     * Annotations on this variable. Lazily created.
     */
    private List<GeneratedAnnotationUse> annotations;

    /**
     * Helper class to implement {@link Generifiable}.
     */
    private final AbstractGenerifiable generifiable = new AbstractGenerifiable() {
        protected CodeModel owner() {
            return GeneratedClass.this.owner();
        }
    };

    GeneratedClass(ClassContainer parent, int mods, String name, GeneratedClassType classTypeval) {
        this(mods, name, parent, parent.owner(), classTypeval);
    }

    /**
     * Constructor for creating anonymous inner class.
     */
    GeneratedClass(
            CodeModel owner,
            int mods,
            String name) {
        this(mods, name, null, owner);
    }

    private GeneratedClass(
            int mods,
            String name,
            ClassContainer parent,
            CodeModel owner) {
        this(mods, name, parent, owner, GeneratedClassType.CLASS);
    }

    /**
     * TypeReference constructor
     *
     * @param mods Modifiers for this class declaration
     * @param name Name of this class
     */
    private GeneratedClass(
            int mods,
            String name,
            ClassContainer parent,
            CodeModel owner,
            GeneratedClassType classTypeVal) {
        super(owner);

        if (name != null) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException("TypeReference name empty");
            }

            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                String msg =
                        "TypeReference name "
                                + name
                                + " contains illegal character"
                                + " for beginning of identifier: "
                                + name.charAt(0);
                throw new IllegalArgumentException(msg);
            }
            for (int i = 1; i < name.length(); i++) {
                if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                    String msg =
                            "TypeReference name "
                                    + name
                                    + " contains illegal character "
                                    + name.charAt(i);
                    throw new IllegalArgumentException(msg);
                }
            }
        }

        this.classType = classTypeVal;
        if (isInterface()) {
            this.mods = Modifiers.forInterface(mods);
        } else {
            this.mods = Modifiers.forClass(mods);
        }

        this.name = name;

        this.outer = parent;
    }

    /**
     * Returns true if this is an anonymous class.
     */
    public final boolean isAnonymous() {
        return name == null;
    }

    /**
     * This class extends the specifed class.
     *
     * @param superClass Superclass for this class
     * @return This class
     */
    public GeneratedClass _extends(TypeReference superClass) {
        if (this.classType == GeneratedClassType.INTERFACE) {
            if (superClass.isInterface()) {
                return this._implements(superClass);
            } else {
                throw new IllegalArgumentException("unable to set the super class for an interface");
            }
        }
        if (superClass == null) {
            throw new NullPointerException();
        }

        for (TypeReference o = superClass.outer(); o != null; o = o.outer()) {
            if (this == o) {
                throw new IllegalArgumentException("Illegal class inheritance loop." +
                        "  Outer class " + this.name + " may not subclass from inner class: " + o.name());
            }
        }

        this.superClass = superClass;
        return this;
    }

    public GeneratedClass _extends(Class<?> superClass) {
        return _extends(owner().ref(superClass));
    }

    /**
     * Returns the class extended by this class.
     */
    public TypeReference _extends() {
        if (superClass == null) {
            superClass = owner().ref(Object.class);
        }
        return superClass;
    }

    /**
     * This class implements the specifed interface.
     *
     * @param iface Interface that this class implements
     * @return This class
     */
    public GeneratedClass _implements(TypeReference iface) {
        interfaces.add(iface);
        return this;
    }

    public GeneratedClass _implements(Class<?> iface) {
        return _implements(owner().ref(iface));
    }

    /**
     * Returns an iterator that walks the nested classes defined in this
     * class.
     */
    public Iterator<TypeReference> _implements() {
        return interfaces.iterator();
    }

    /**
     * TypeReference name accessor.
     * <p/>
     * <p/>
     * For example, for <code>java.util.List</code>, this method
     * returns <code>"List"</code>"
     *
     * @return Name of this class
     */
    public String name() {
        return name;
    }

    /**
     * If the named enum already exists, the reference to it is returned.
     * Otherwise this method generates a new enum reference with the given
     * name and returns it.
     *
     * @param name The name of the constant.
     * @return The generated type-safe enum constant.
     */
    public EnumConstant enumConstant(String name) {
        EnumConstant ec = enumConstantsByName.get(name);
        if (null == ec) {
            ec = new EnumConstant(this, name);
            enumConstantsByName.put(name, ec);
        }
        return ec;
    }

    /**
     * Gets the fully qualified name of this class.
     */
    public String fullName() {
        if (outer instanceof GeneratedClass) {
            return ((GeneratedClass) outer).fullName() + '.' + name();
        }

        GeneratedPackage p = _package();
        if (p.isUnnamed()) {
            return name();
        } else {
            return p.name() + '.' + name();
        }
    }

    @Override
    public String binaryName() {
        if (outer instanceof GeneratedClass) {
            return ((GeneratedClass) outer).binaryName() + '$' + name();
        } else {
            return fullName();
        }
    }

    public boolean isInterface() {
        return this.classType == GeneratedClassType.INTERFACE;
    }

    public boolean isAbstract() {
        return mods.isAbstract();
    }

    /**
     * Adds a field to the list of field members of this DefinedClass.
     *
     * @param mods Modifiers for this field
     * @param type Type of this field
     * @param name Name of this field
     * @return Newly generated field
     */
    public GeneratedField field(int mods, Type type, String name) {
        return field(mods, type, name, null);
    }

    public GeneratedField field(int mods, Class<?> type, String name) {
        return field(mods, owner()._ref(type), name);
    }

    /**
     * Adds a field to the list of field members of this DefinedClass.
     *
     * @param mods Modifiers for this field.
     * @param type Type of this field.
     * @param name Name of this field.
     * @param init Initial value of this field.
     * @return Newly generated field
     */
    public GeneratedField field(
            int mods,
            Type type,
            String name,
            GeneratedExpression init) {
        GeneratedField f = new GeneratedField(this, Modifiers.forField(mods), type, name, init);

        if (fields.containsKey(name)) {
            throw new IllegalArgumentException("trying to create the same field twice: " + name);
        }

        fields.put(name, f);
        return f;
    }

    /**
     * This method indicates if the interface
     * is an annotationTypeDeclaration
     */
    public boolean isAnnotationTypeDeclaration() {
        return this.classType == GeneratedClassType.ANNOTATION_TYPE_DECL;


    }

    /**
     * Add an annotationType Declaration to this package
     *
     * @param name Name of the annotation Type declaration to be added to this package
     * @return newly created Annotation Type Declaration
     * @throws ClassAlreadyExistsException When the specified class/interface was already created.
     */
    public GeneratedClass _annotationTypeDeclaration(String name) throws ClassAlreadyExistsException {
        return _class(Modifier.PUBLIC, name, GeneratedClassType.ANNOTATION_TYPE_DECL);
    }

    /**
     * Add a public enum to this package
     *
     * @param name Name of the enum to be added to this package
     * @return newly created Enum
     * @throws ClassAlreadyExistsException When the specified class/interface was already created.
     */
    public GeneratedClass _enum(String name) throws ClassAlreadyExistsException {
        return _class(Modifier.PUBLIC, name, GeneratedClassType.ENUM);
    }

    /**
     * Add a public enum to this package
     *
     * @param name Name of the enum to be added to this package
     * @param mods Modifiers for this enum declaration
     * @return newly created Enum
     * @throws ClassAlreadyExistsException When the specified class/interface was already created.
     */
    public GeneratedClass _enum(int mods, String name) throws ClassAlreadyExistsException {
        return _class(mods, name, GeneratedClassType.ENUM);
    }


    public GeneratedClassType getClassType() {
        return this.classType;
    }

    public GeneratedField field(
            int mods,
            Class<?> type,
            String name,
            GeneratedExpression init) {
        return field(mods, owner()._ref(type), name, init);
    }

    /**
     * Returns all the fields declred in this class.
     * The returned {@link java.util.Map} is a read-only live view.
     *
     * @return always non-null.
     */
    public Map<String, GeneratedField> fields() {
        return Collections.unmodifiableMap(fields);
    }

    /**
     * Removes a {@link GeneratedField} from this class.
     *
     * @throws IllegalArgumentException if the given field is not a field on this class.
     */
    public void removeField(GeneratedField field) {
        if (fields.remove(field.name()) != field) {
            throw new IllegalArgumentException();
        }
    }

    /**
     * Creates, if necessary, and returns the static initializer
     * for this class.
     *
     * @return JBlock containing initialization statements for this class
     */
    public GeneratedBlock init() {
        if (init == null) {
            init = new GeneratedBlock();
        }
        return init;
    }

    /**
     * Adds a constructor to this class.
     *
     * @param mods Modifiers for this constructor
     */
    public GeneratedMethod constructor(int mods) {
        GeneratedMethod c = new GeneratedMethod(mods, this);
        constructors.add(c);
        return c;
    }

    /**
     * Returns an iterator that walks the constructors defined in this class.
     */
    public Iterator<GeneratedMethod> constructors() {
        return constructors.iterator();
    }

    /**
     * Looks for a method that has the specified method signature
     * and return it.
     *
     * @return null if not found.
     */
    public GeneratedMethod getConstructor(Type[] argTypes) {
        for (GeneratedMethod m : constructors) {
            if (m.hasSignature(argTypes)) {
                return m;
            }
        }
        return null;
    }

    /**
     * Add a method to the list of method members of this DefinedClass instance.
     *
     * @param mods Modifiers for this method
     * @param type Return type for this method
     * @param name Name of the method
     * @return Newly generated Method
     */
    public GeneratedMethod method(int mods, Type type, String name) {
        // XXX problems caught in M constructor
        GeneratedMethod m = new GeneratedMethod(this, mods, type, name);
        methods.add(m);
        return m;
    }

    public GeneratedMethod method(int mods, Class<?> type, String name) {
        return method(mods, owner()._ref(type), name);
    }

    public GeneratedMethod method(int mods, Class<?> type, Class<?> narrowedType, String name) {
        return method(mods, owner()._ref(type).boxify().narrow(narrowedType), name);
    }

    /**
     * Returns the set of methods defined in this class.
     */
    public Collection<GeneratedMethod> methods() {
        return methods;
    }

    /**
     * Looks for a method that has the specified method signature
     * and return it.
     *
     * @return null if not found.
     */
    public GeneratedMethod getMethod(String name, Type[] argTypes) {
        for (GeneratedMethod m : methods) {
            if (!m.name().equals(name)) {
                continue;
            }

            if (m.hasSignature(argTypes)) {
                return m;
            }
        }
        return null;
    }

    public boolean isClass() {
        return true;
    }

    public boolean isPackage() {
        return false;
    }

    public GeneratedPackage getPackage() {
        return parentContainer().getPackage();
    }

    /**
     * Add a new nested class to this class.
     *
     * @param mods Modifiers for this class declaration
     * @param name Name of class to be added to this package
     * @return Newly generated class
     */
    public GeneratedClass _class(int mods, String name)
            throws ClassAlreadyExistsException {
        return _class(mods, name, GeneratedClassType.CLASS);
    }

    /**
     * {@inheritDoc}
     *
     * @deprecated
     */
    public GeneratedClass _class(int mods, String name, boolean isInterface) throws ClassAlreadyExistsException {
        return _class(mods, name, isInterface ? GeneratedClassType.INTERFACE : GeneratedClassType.CLASS);
    }

    public GeneratedClass _class(int mods, String name, GeneratedClassType classTypeVal)
            throws ClassAlreadyExistsException {

        String NAME;
        if (CodeModel.isCaseSensitiveFileSystem) {
            NAME = name.toUpperCase();
        } else {
            NAME = name;
        }

        if (getClasses().containsKey(NAME)) {
            throw new ClassAlreadyExistsException(getClasses().get(NAME));
        } else {
            // XXX problems caught in the NC constructor
            GeneratedClass c = new GeneratedClass(this, mods, name, classTypeVal);
            getClasses().put(NAME, c);
            return c;
        }
    }

    /**
     * Add a new public nested class to this class.
     */
    public GeneratedClass _class(String name) {
        try {
            return _class(Modifier.PUBLIC, name);
        } catch (ClassAlreadyExistsException caee) {
            return caee.getExistingClass();
        }
    }

    /**
     * Add an interface to this package.
     *
     * @param mods Modifiers for this interface declaration
     * @param name Name of interface to be added to this package
     * @return Newly generated interface
     */
    public GeneratedClass _interface(int mods, String name)
            throws ClassAlreadyExistsException {
        return _class(mods, name, GeneratedClassType.INTERFACE);
    }

    /**
     * Adds a public interface to this package.
     */
    public GeneratedClass _interface(String name)
            throws ClassAlreadyExistsException {
        return _interface(Modifier.PUBLIC, name);
    }

    /**
     * Creates, if necessary, and returns the class javadoc for this
     * DefinedClass
     *
     * @return JDocComment containing javadocs for this class
     */
    public GeneratedJavaDocComment javadoc() {
        if (jdoc == null) {
            jdoc = new GeneratedJavaDocComment(owner());
        }
        return jdoc;
    }

    /**
     * Mark this file as hidden, so that this file won't be
     * generated.
     * <p/>
     * <p/>
     * This feature could be used to generate code that refers
     * to class X, without actually generating X.java.
     */
    public void hide() {
        hideFile = true;
    }

    public boolean isHidden() {
        return hideFile;
    }

    /**
     * Returns an iterator that walks the nested classes defined in this
     * class.
     */
    public final Iterator<GeneratedClass> classes() {
        if (classes == null) {
            return Collections.<GeneratedClass>emptyList().iterator();
        } else {
            return classes.values().iterator();
        }
    }

    private Map<String, GeneratedClass> getClasses() {
        if (classes == null) {
            classes = new TreeMap<String, GeneratedClass>();
        }
        return classes;
    }


    /**
     * Returns all the nested classes defined in this class.
     */
    public final TypeReference[] listClasses() {
        if (classes == null) {
            return new TypeReference[0];
        } else {
            return classes.values().toArray(new TypeReference[classes.values().size()]);
        }
    }

    @Override
    public TypeReference outer() {
        if (outer.isClass()) {
            return (TypeReference) outer;
        } else {
            return null;
        }
    }

    public void declare(Formatter f) {
        if (jdoc != null) {
            f.nl().g(jdoc);
        }

        if (annotations != null) {
            for (GeneratedAnnotationUse annotation : annotations) {
                f.g(annotation).nl();
            }
        }

        f.g(mods).p(classType.getDeclarationToken()).id(name).d(generifiable);

        if (superClass != null && superClass != owner().ref(Object.class)) {
            f.nl().i().p("extends").g(superClass).nl().o();
        }

        if (!interfaces.isEmpty()) {
            if (superClass == null) {
                f.nl();
            }
            f.i().p(classType == GeneratedClassType.INTERFACE ? "extends" : "implements");
            f.g(interfaces);
            f.nl().o();
        }
        declareBody(f);
    }

    /**
     * prints the body of a class.
     */
    protected void declareBody(Formatter f) {
        f.p('{').nl().nl().i();
        boolean first = true;

        if (!enumConstantsByName.isEmpty()) {
            for (EnumConstant c : enumConstantsByName.values()) {
                if (!first) {
                    f.p(',').nl();
                }
                f.d(c);
                first = false;
            }
            f.p(';').nl();
        }

        for (GeneratedField field : fields.values()) {
            f.d(field);
        }
        if (init != null) {
            f.nl().p("static").s(init);
        }
        for (GeneratedMethod m : constructors) {
            f.nl().d(m);
        }
        for (GeneratedMethod m : methods) {
            f.nl().d(m);
        }
        if (classes != null) {
            for (GeneratedClass dc : classes.values()) {
                f.nl().d(dc);
            }
        }


        if (directBlock != null) {
            f.p(directBlock);
        }
        f.nl().o().p('}').nl();
    }

    /**
     * Places the given string directly inside the generated class.
     * <p/>
     * This method can be used to add methods/fields that are not
     * generated by CodeModel.
     * This method should be used only as the last resort.
     */
    public void direct(String string) {
        if (directBlock == null) {
            directBlock = string;
        } else {
            directBlock += string;
        }
    }

    public final GeneratedPackage _package() {
        ClassContainer p = outer;
        while (!(p instanceof GeneratedPackage)) {
            p = p.parentContainer();
        }
        return (GeneratedPackage) p;
    }

    public final ClassContainer parentContainer() {
        return outer;
    }

    public TypeVariable generify(String name) {
        return generifiable.generify(name);
    }

    public TypeVariable generify(String name, Class<?> bound) {
        return generifiable.generify(name, bound);
    }

    public TypeVariable generify(String name, TypeReference bound) {
        return generifiable.generify(name, bound);
    }

    @Override
    public TypeVariable[] typeParams() {
        return generifiable.typeParams();
    }

    protected TypeReference substituteParams(
            TypeVariable[] variables,
            List<TypeReference> bindings) {
        return this;
    }

    /**
     * Adding ability to annotate a class
     *
     * @param clazz The annotation class to annotate the class with
     */
    public GeneratedAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return annotate(owner().ref(clazz));
    }

    /**
     * Adding ability to annotate a class
     *
     * @param clazz The annotation class to annotate the class with
     */
    public GeneratedAnnotationUse annotate(TypeReference clazz) {
        if (annotations == null) {
            annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        GeneratedAnnotationUse a = new GeneratedAnnotationUse(clazz);
        annotations.add(a);
        return a;
    }

    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    /**
     * {@link Annotable#annotations()}
     */
    public Collection<GeneratedAnnotationUse> annotations() {
        if (annotations == null) {
            annotations = new ArrayList<GeneratedAnnotationUse>();
        }
        return Collections.unmodifiableCollection(annotations);
    }

    /**
     * @return the current modifiers of this class.
     *         Always return non-null valid object.
     */
    public Modifiers mods() {
        return mods;
    }

    /**
     * Generate a setter method for the specified field
     *
     * @param field Field for which a setter method needs to be build
     * @return A setter method
     */
    public GeneratedMethod setter(GeneratedField field) {
        GeneratedMethod setter = this.method(Modifier.PUBLIC, owner().VOID, "set" + StringUtils.capitalize(field.name()));
        setter.javadoc().add("Sets " + field.name());
        setter.javadoc().addParam("value Value to set");
        GeneratedVariable value = setter.param(field.type(), "value");
        setter.body().assign(ExpressionFactory._this().ref(field), value);

        return setter;
    }

    /**
     * Generate a setter and puts an override annotation on it
     */
    public GeneratedMethod setterOverride(GeneratedField field) {
        GeneratedMethod setter = setter(field);
        setter.annotate(Override.class);
        return setter;
    }

    /**
     * Generate a getter method for the specified field
     *
     * @param field Field for which a getter method needs to be build
     * @return A getter method
     */
    public GeneratedMethod getter(GeneratedField field) {
        GeneratedMethod getter = this.method(Modifier.PUBLIC, field.type(), "get" + StringUtils.capitalize(field.name()));
        getter.javadoc().add("Retrieves " + field.name());
        getter.body()._return(ExpressionFactory._this().ref(field));

        return getter;
    }

    /**
     * Find all the classes that inherit from this one.
     *
     * @return A list of {@link GeneratedClass} that inherit from this one
     */
    public List<GeneratedClass> superclasses() {
        List<GeneratedClass> superclasses = new ArrayList<GeneratedClass>();
        Iterator<GeneratedPackage> packageIterator = owner().packages();
        while (packageIterator.hasNext()) {
            Iterator<GeneratedClass> classIterator = packageIterator.next().classes();
            while (classIterator.hasNext()) {
                GeneratedClass classToBeTested = classIterator.next();
                if (classToBeTested == this) {
                    continue;
                }
                if (classToBeTested._extends() == this) {
                    superclasses.add(classToBeTested);
                }
            }
        }

        return superclasses;
    }

    private GeneratedClass directSuperclass() {
        List<GeneratedClass> superclasses = superclasses();

        if (superclasses.size() > 1) {
            throw new IllegalArgumentException("Cannot find the direct superclass of " + this.binaryName());
        }

        if (superclasses.size() == 0) {
            return null;
        }

        return superclasses.get(0);
    }

    /**
     * Find the top level class that inherits from this one.
     * <p/>
     * If the class is inherited by more than one superclass
     * this method will fail.
     *
     * @return
     */
    public GeneratedClass topLevelClass() throws IllegalArgumentException {
        GeneratedClass topLevelClass = this;

        while (topLevelClass.directSuperclass() != null) {
            topLevelClass = topLevelClass.directSuperclass();
        }

        return topLevelClass;
    }

    @Override
    public String toString() {
        return "DefinedClass{" +
                "name='" + name + '\'' +
                '}';
    }

    /**
     * Returns whether this class implements the provided interface or not
     */
    public boolean implementsClass(Class clazz) {
        Iterator<TypeReference> interfaces = this._implements();
        while (interfaces.hasNext()) {
            TypeReference interfaze = interfaces.next();
            if (clazz.getName().equals(interfaze.fullName())) {
                return true;
            }
        }
        return false;
    }

    public GeneratedField muleContextField() {
        if (!fields.containsKey(MULE_CONTEXT_FIELD_NAME)) {
            GeneratedField muleContext = field(Modifier.PROTECTED, owner().ref(MuleContext.class), MULE_CONTEXT_FIELD_NAME);
            muleContext.javadoc().add(MULE_CONTEXT_JAVADOC);
            setter(muleContext);
            getter(muleContext);

            fields.put(MULE_CONTEXT_FIELD_NAME, muleContext);
        }

        return fields.get(MULE_CONTEXT_FIELD_NAME);
    }

    public GeneratedField flowConstructField() {
        if (!fields.containsKey(FLOW_CONSTRUCT_FIELD_NAME)) {
            GeneratedField flowConstruct = field(Modifier.PROTECTED, owner().ref(FlowConstruct.class), FLOW_CONSTRUCT_FIELD_NAME);
            flowConstruct.javadoc().add(FLOW_CONSTRUCT_JAVADOC);
            setter(flowConstruct);
            getter(flowConstruct);

            fields.put(FLOW_CONSTRUCT_FIELD_NAME, flowConstruct);
        }

        return fields.get(FLOW_CONSTRUCT_FIELD_NAME);
    }

}
