/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.writer.FilterCodeWriter;

public class ProgressCodeWriter
extends FilterCodeWriter {
    private final PrintStream progress;

    public ProgressCodeWriter(CodeWriter output, PrintStream progress) {
        super(output);
        this.progress = progress;
        if (progress == null) {
            throw new IllegalArgumentException();
        }
    }

    public OutputStream openBinary(GeneratedPackage pkg, String fileName) throws IOException {
        this.report(pkg, fileName);
        return super.openBinary(pkg, fileName);
    }

    public Writer openSource(GeneratedPackage pkg, String fileName) throws IOException {
        this.report(pkg, fileName);
        return super.openSource(pkg, fileName);
    }

    private void report(GeneratedPackage pkg, String fileName) {
        if (pkg.isUnnamed()) {
            this.progress.println(fileName);
        } else {
            this.progress.println(pkg.name().replace('.', '/') + "/" + fileName);
        }
    }
}

