/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.GeneratedAnonymousClass;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.NarrowedClass;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;

public final class Formatter {
    private HashMap<String, ReferenceList> collectedReferences;
    private HashSet<TypeReference> importedClasses;
    private Mode mode = Mode.PRINTING;
    private int indentLevel;
    private final String indentSpace;
    private final PrintWriter pw;
    private char lastChar = '\u0000';
    private boolean atBeginningOfLine = true;
    private GeneratedPackage javaLang;
    static final char CLOSE_TYPE_ARGS = '\uffff';

    public Formatter(PrintWriter s, String space) {
        this.pw = s;
        this.indentSpace = space;
        this.collectedReferences = new HashMap();
        this.importedClasses = new HashSet();
    }

    public Formatter(PrintWriter s) {
        this(s, "    ");
    }

    public Formatter(Writer w) {
        this(new PrintWriter(w));
    }

    public void close() {
        this.pw.close();
    }

    public boolean isPrinting() {
        return this.mode == Mode.PRINTING;
    }

    public Formatter o() {
        --this.indentLevel;
        return this;
    }

    public Formatter i() {
        ++this.indentLevel;
        return this;
    }

    private boolean needSpace(char c1, char c2) {
        if (c1 == ']' && c2 == '{') {
            return true;
        }
        if (c1 == ';') {
            return true;
        }
        if (c1 == '\uffff') {
            return c2 != '(';
        }
        if (c1 == ')' && c2 == '{') {
            return true;
        }
        if (c1 == ',' || c1 == '=') {
            return true;
        }
        if (c2 == '=') {
            return true;
        }
        if (Character.isDigit(c1)) {
            return c2 != '(' && c2 != ')' && c2 != ';' && c2 != ',';
        }
        if (Character.isJavaIdentifierPart(c1)) {
            switch (c2) {
                case '+': 
                case '>': 
                case '@': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return Character.isJavaIdentifierStart(c2);
        }
        if (Character.isJavaIdentifierStart(c2)) {
            switch (c1) {
                case ')': 
                case '+': 
                case ']': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
        if (Character.isDigit(c2)) {
            return c1 != '(';
        }
        return false;
    }

    private void spaceIfNeeded(char c) {
        if (this.atBeginningOfLine) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.pw.print(this.indentSpace);
            }
            this.atBeginningOfLine = false;
        } else if (this.lastChar != '\u0000' && this.needSpace(this.lastChar, c)) {
            this.pw.print(' ');
        }
    }

    public Formatter p(char c) {
        if (this.mode == Mode.PRINTING) {
            if (c == '\uffff') {
                this.pw.print('>');
            } else {
                this.spaceIfNeeded(c);
                this.pw.print(c);
            }
            this.lastChar = c;
        }
        return this;
    }

    public Formatter p(String s) {
        if (this.mode == Mode.PRINTING) {
            this.spaceIfNeeded(s.charAt(0));
            this.pw.print(s);
            this.lastChar = s.charAt(s.length() - 1);
        }
        return this;
    }

    public Formatter t(Type type) {
        if (type.isReference()) {
            return this.t((TypeReference)type);
        }
        return this.g(type);
    }

    public Formatter t(TypeReference type) {
        switch (this.mode) {
            case PRINTING: {
                if (this.importedClasses.contains(type)) {
                    this.p(type.name());
                    break;
                }
                if (type.outer() != null) {
                    this.t(type.outer()).p('.').p(type.name());
                    break;
                }
                this.p(type.fullName());
                break;
            }
            case COLLECTING: {
                String shortName = type.name();
                if (this.collectedReferences.containsKey(shortName)) {
                    this.collectedReferences.get(shortName).add(type);
                    break;
                }
                ReferenceList tl = new ReferenceList();
                tl.add(type);
                this.collectedReferences.put(shortName, tl);
            }
        }
        return this;
    }

    public Formatter id(String id) {
        switch (this.mode) {
            case PRINTING: {
                this.p(id);
                break;
            }
            case COLLECTING: {
                if (this.collectedReferences.containsKey(id)) {
                    if (!this.collectedReferences.get(id).getClasses().isEmpty()) {
                        for (TypeReference type : this.collectedReferences.get(id).getClasses()) {
                            if (type.outer() == null) continue;
                            this.collectedReferences.get(id).setId(false);
                            return this;
                        }
                    }
                    this.collectedReferences.get(id).setId(true);
                    break;
                }
                ReferenceList tl = new ReferenceList();
                tl.setId(true);
                this.collectedReferences.put(id, tl);
            }
        }
        return this;
    }

    public Formatter nl() {
        if (this.mode == Mode.PRINTING) {
            this.pw.println();
            this.lastChar = '\u0000';
            this.atBeginningOfLine = true;
        }
        return this;
    }

    public Formatter g(Generable g) {
        if (g == null) {
            System.out.println();
        }
        g.generate(this);
        return this;
    }

    public Formatter g(Collection<? extends Generable> list) {
        boolean first = true;
        if (!list.isEmpty()) {
            for (Generable generable : list) {
                if (!first) {
                    this.p(',');
                }
                this.g(generable);
                first = false;
            }
        }
        return this;
    }

    public Formatter d(Declaration d) {
        d.declare(this);
        return this;
    }

    public Formatter s(Statement s) {
        s.state(this);
        return this;
    }

    public Formatter b(GeneratedVariable v) {
        v.bind(this);
        return this;
    }

    void write(GeneratedClass c) {
        this.mode = Mode.COLLECTING;
        this.d(c);
        this.javaLang = c.owner()._package("java.lang");
        for (ReferenceList tl : this.collectedReferences.values()) {
            if (tl.collisions(c) || tl.isId()) continue;
            assert (tl.getClasses().size() == 1);
            this.importedClasses.add(tl.getClasses().get(0));
        }
        this.importedClasses.add(c);
        this.mode = Mode.PRINTING;
        assert (c.parentContainer().isPackage()) : "this method is only for a pacakge-level class";
        GeneratedPackage pkg = (GeneratedPackage)c.parentContainer();
        if (!pkg.isUnnamed()) {
            this.nl().d(pkg);
            this.nl();
        }
        Object[] imports = this.importedClasses.toArray(new TypeReference[this.importedClasses.size()]);
        Arrays.sort(imports);
        for (Object clazz : imports) {
            if (this.supressImport((TypeReference)clazz, c)) continue;
            if (clazz instanceof NarrowedClass) {
                clazz = ((TypeReference)clazz).erasure();
            }
            this.p("import").p(((Type)clazz).fullName()).p(';').nl();
        }
        this.nl();
        this.d(c);
    }

    private boolean supressImport(TypeReference clazz, TypeReference c) {
        if (clazz instanceof NarrowedClass) {
            clazz = clazz.erasure();
        }
        if (clazz instanceof GeneratedAnonymousClass) {
            clazz = clazz._extends();
        }
        if (clazz._package().isUnnamed()) {
            return true;
        }
        String packageName = clazz._package().name();
        if (packageName.equals("java.lang")) {
            return true;
        }
        return clazz._package() == c._package() && clazz.outer() == null;
    }

    final class ReferenceList {
        private final ArrayList<TypeReference> classes = new ArrayList();
        private boolean id;

        ReferenceList() {
        }

        public boolean collisions(GeneratedClass enclosingClass) {
            if (this.classes.size() > 1) {
                return true;
            }
            if (this.id && this.classes.size() != 0) {
                return true;
            }
            for (TypeReference c : this.classes) {
                if (c instanceof GeneratedAnonymousClass) {
                    c = c._extends();
                }
                if (c._package() == Formatter.this.javaLang) {
                    Iterator<GeneratedClass> itr = enclosingClass._package().classes();
                    while (itr.hasNext()) {
                        GeneratedClass n = itr.next();
                        if (!n.name().equals(c.name())) continue;
                        return true;
                    }
                }
                if (c.outer() == null) continue;
                return true;
            }
            return false;
        }

        public void add(TypeReference clazz) {
            if (!this.classes.contains(clazz)) {
                this.classes.add(clazz);
            }
        }

        public List<TypeReference> getClasses() {
            return this.classes;
        }

        public void setId(boolean value) {
            this.id = value;
        }

        public boolean isId() {
            return this.id && this.classes.size() == 0;
        }
    }

    private static enum Mode {
        COLLECTING,
        PRINTING;

    }
}

