/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code.writer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.writer.FilterCodeWriter;

public class PrologCodeWriter
extends FilterCodeWriter {
    private final String prolog;

    public PrologCodeWriter(CodeWriter core, String prolog) {
        super(core);
        this.prolog = prolog;
    }

    @Override
    public Writer openSource(GeneratedPackage pkg, String fileName) throws IOException {
        Writer w = super.openSource(pkg, fileName);
        PrintWriter out = new PrintWriter(w);
        if (this.prolog != null) {
            int idx;
            out.println("//");
            String s = this.prolog;
            while ((idx = s.indexOf(10)) != -1) {
                out.println("// " + s.substring(0, idx));
                s = s.substring(idx + 1);
            }
            out.println("//");
            out.println();
        }
        out.flush();
        return w;
    }
}

