/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.Iterator;
import java.util.List;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;

public final class TypeVariable
extends TypeReference
implements Declaration {
    private final String name;
    private TypeReference bound;

    TypeVariable(CodeModel owner, String _name) {
        super(owner);
        this.name = _name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String fullName() {
        return this.name;
    }

    @Override
    public GeneratedPackage _package() {
        return null;
    }

    public TypeVariable bound(TypeReference c) {
        if (this.bound != null) {
            throw new IllegalArgumentException("type variable has an existing class bound " + this.bound);
        }
        this.bound = c;
        return this;
    }

    @Override
    public TypeReference _extends() {
        if (this.bound != null) {
            return this.bound;
        }
        return this.owner().ref(Object.class);
    }

    @Override
    public Iterator<TypeReference> _implements() {
        return this.bound._implements();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public void declare(Formatter f) {
        f.id(this.name);
        if (this.bound != null) {
            f.p("extends").g(this.bound);
        }
    }

    @Override
    protected TypeReference substituteParams(TypeVariable[] variables, List<TypeReference> bindings) {
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i] != this) continue;
            return bindings.get(i);
        }
        return this;
    }

    @Override
    public void generate(Formatter f) {
        f.id(this.name);
    }
}

