

package org.mule.devkit.model.code.writer;

import static javax.tools.StandardLocation.SOURCE_OUTPUT;

import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.GeneratedPackage;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

import javax.annotation.processing.Filer;

public final class FilerCodeWriter extends CodeWriter {

    private final Filer filer;

    public FilerCodeWriter(Filer filer) {
        this.filer = filer;
    }

    @Override
    public OutputStream openBinary(GeneratedPackage pkg, String fileName) throws IOException {
        if (pkg != null) {
            return filer.createResource(SOURCE_OUTPUT, pkg.name(), fileName).openOutputStream();
        } else {
            return filer.createResource(SOURCE_OUTPUT, "", fileName).openOutputStream();
        }
    }

    @Override
    public Writer openSource(GeneratedPackage pkg, String fileName) throws IOException {
        String name;
        if (pkg.isUnnamed()) {
            name = fileName;
        } else {
            name = pkg.name() + '.' + fileName;
        }

        name = name.substring(0, name.length() - 5);   // strip ".java"

        return filer.createSourceFile(name).openWriter();
    }

    @Override
    public void close() {
    }
}