/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mule.devkit.model.code.ArrayClass;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldRef;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.NarrowedClass;
import org.mule.devkit.model.code.NullType;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.PrimitiveType;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.TypeWildcard;
import org.mule.devkit.model.code.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeReference
extends Type {
    private final CodeModel _owner;
    protected static final TypeVariable[] EMPTY_ARRAY = new TypeVariable[0];
    private TypeReference arrayClass;

    protected TypeReference(CodeModel _owner) {
        this._owner = _owner;
    }

    @Override
    public abstract String name();

    public abstract Package _package();

    public TypeReference outer() {
        return null;
    }

    @Override
    public final CodeModel owner() {
        return this._owner;
    }

    public abstract TypeReference _extends();

    public abstract Iterator<TypeReference> _implements();

    public TypeVariable[] typeParams() {
        return EMPTY_ARRAY;
    }

    public abstract boolean isInterface();

    public abstract boolean isAbstract();

    public PrimitiveType getPrimitiveType() {
        return null;
    }

    @Override
    public TypeReference boxify() {
        return this;
    }

    @Override
    public Type unboxify() {
        PrimitiveType pt = this.getPrimitiveType();
        return pt == null ? this : pt;
    }

    @Override
    public TypeReference erasure() {
        return this;
    }

    public final boolean isAssignableFrom(TypeReference derived) {
        if (derived instanceof NullType) {
            return true;
        }
        if (this == derived) {
            return true;
        }
        if (this == this._package().owner().ref(Object.class)) {
            return true;
        }
        TypeReference b = derived._extends();
        if (b != null && this.isAssignableFrom(b)) {
            return true;
        }
        if (this.isInterface()) {
            Iterator<TypeReference> itfs = derived._implements();
            while (itfs.hasNext()) {
                if (!this.isAssignableFrom(itfs.next())) continue;
                return true;
            }
        }
        return false;
    }

    public final TypeReference getBaseClass(TypeReference baseType) {
        TypeReference bc;
        if (this.erasure().equals(baseType)) {
            return this;
        }
        TypeReference b = this._extends();
        if (b != null && (bc = b.getBaseClass(baseType)) != null) {
            return bc;
        }
        Iterator<TypeReference> itfs = this._implements();
        while (itfs.hasNext()) {
            TypeReference bc2 = itfs.next().getBaseClass(baseType);
            if (bc2 == null) continue;
            return bc2;
        }
        return null;
    }

    public final TypeReference getBaseClass(Class<?> baseType) {
        return this.getBaseClass(this.owner().ref(baseType));
    }

    @Override
    public TypeReference array() {
        if (this.arrayClass == null) {
            this.arrayClass = new ArrayClass(this.owner(), this);
        }
        return this.arrayClass;
    }

    public TypeReference narrow(Class<?> clazz) {
        return this.narrow(this.owner().ref(clazz));
    }

    public TypeReference narrow(Class<?> ... clazz) {
        TypeReference[] r = new TypeReference[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            r[i] = this.owner().ref(clazz[i]);
        }
        return this.narrow(r);
    }

    public TypeReference narrow(TypeReference clazz) {
        return new NarrowedClass(this, clazz);
    }

    public TypeReference narrow(Type type) {
        return this.narrow(type.boxify());
    }

    public TypeReference narrow(TypeReference ... clazz) {
        return new NarrowedClass(this, Arrays.asList((Object[])clazz.clone()));
    }

    public TypeReference narrow(List<? extends TypeReference> clazz) {
        return new NarrowedClass(this, new ArrayList<TypeReference>(clazz));
    }

    public List<TypeReference> getTypeParameters() {
        return Collections.emptyList();
    }

    public final boolean isParameterized() {
        return this.erasure() != this;
    }

    public final TypeReference wildcard() {
        return new TypeWildcard(this);
    }

    protected abstract TypeReference substituteParams(TypeVariable[] var1, List<TypeReference> var2);

    @Override
    public String toString() {
        return this.getClass().getName() + '(' + this.name() + ')';
    }

    public final Expression dotclass() {
        return ExpressionFactory.dotclass(this);
    }

    public final Invocation staticInvoke(Method method) {
        return new Invocation(this, method);
    }

    public final Invocation staticInvoke(String method) {
        return new Invocation(this, method);
    }

    public final FieldRef staticRef(String field) {
        return new FieldRef((Type)this, field);
    }

    public final FieldRef staticRef(Variable field) {
        return new FieldRef((Type)this, field);
    }

    @Override
    public void generate(Formatter f) {
        f.t(this);
    }

    void printLink(Formatter f) {
        f.p("{@link ").g(this).p('}');
    }
}

