/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.StandardLocation;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.Package;

public final class FilerCodeWriter
extends CodeWriter {
    private final Filer filer;

    public FilerCodeWriter(Filer filer) {
        this.filer = filer;
    }

    public OutputStream openBinary(Package pkg, String fileName) throws IOException {
        if (pkg != null) {
            return this.filer.createResource(StandardLocation.SOURCE_OUTPUT, pkg.name(), fileName, new Element[0]).openOutputStream();
        }
        return this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "", fileName, new Element[0]).openOutputStream();
    }

    public Writer openSource(Package pkg, String fileName) throws IOException {
        String name = pkg.isUnnamed() ? fileName : pkg.name() + '.' + fileName;
        name = name.substring(0, name.length() - 5);
        return this.filer.createSourceFile(name, new Element[0]).openWriter();
    }

    public void close() {
    }
}

