/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.writer.FilterCodeWriter;

public class ProgressCodeWriter
extends FilterCodeWriter {
    private final PrintStream progress;

    public ProgressCodeWriter(CodeWriter output, PrintStream progress) {
        super(output);
        this.progress = progress;
        if (progress == null) {
            throw new IllegalArgumentException();
        }
    }

    public OutputStream openBinary(Package pkg, String fileName) throws IOException {
        this.report(pkg, fileName);
        return super.openBinary(pkg, fileName);
    }

    public Writer openSource(Package pkg, String fileName) throws IOException {
        this.report(pkg, fileName);
        return super.openSource(pkg, fileName);
    }

    private void report(Package pkg, String fileName) {
        if (pkg.isUnnamed()) {
            this.progress.println(fileName);
        } else {
            this.progress.println(pkg.name().replace('.', File.separatorChar) + File.separatorChar + fileName);
        }
    }
}

