/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code.writer;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.Package;

public class ZipCodeWriter
extends CodeWriter {
    private final ZipOutputStream zip;
    private final OutputStream filter;

    public ZipCodeWriter(OutputStream target) {
        this.zip = new ZipOutputStream(target);
        this.filter = new FilterOutputStream(this.zip){

            public void close() {
            }
        };
    }

    public OutputStream openBinary(Package pkg, String fileName) throws IOException {
        String name = fileName;
        if (!pkg.isUnnamed()) {
            name = ZipCodeWriter.toDirName(pkg) + name;
        }
        this.zip.putNextEntry(new ZipEntry(name));
        return this.filter;
    }

    private static String toDirName(Package pkg) {
        return pkg.name().replace('.', '/') + '/';
    }

    public void close() throws IOException {
        this.zip.close();
    }
}

