/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.ArrayCompRef;
import org.mule.devkit.model.code.Assignment;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Atom;
import org.mule.devkit.model.code.Cast;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.FieldRef;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.JArray;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.NarrowedClass;
import org.mule.devkit.model.code.StringLiteral;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;

public abstract class ExpressionFactory {
    private static final Expression __this = new Atom("this");
    private static final Expression __super = new Atom("super");
    private static final Expression __null = new Atom("null");
    public static final Expression TRUE = new Atom("true");
    public static final Expression FALSE = new Atom("false");
    static final String charEscape = "\b\t\n\f\r\"'\\";
    static final String charMacro = "btnfr\"'\\";

    private ExpressionFactory() {
    }

    public static Expression assign(AssignmentTarget lhs, Expression rhs) {
        return new Assignment(lhs, rhs);
    }

    public static Expression assignPlus(AssignmentTarget lhs, Expression rhs) {
        return new Assignment(lhs, rhs, "+");
    }

    public static Invocation _new(TypeReference c) {
        return new Invocation(c);
    }

    public static Invocation _new(Type t) {
        return new Invocation(t);
    }

    public static Invocation invoke(String method) {
        return new Invocation((Expression)null, method);
    }

    public static Invocation invoke(Method method) {
        return new Invocation((Expression)null, method);
    }

    public static Invocation invoke(Expression lhs, Method method) {
        return new Invocation(lhs, method);
    }

    public static Invocation invoke(Expression lhs, String method) {
        return new Invocation(lhs, method);
    }

    public static FieldRef ref(String field) {
        return new FieldRef((Expression)null, field);
    }

    public static FieldRef ref(Expression lhs, Variable field) {
        return new FieldRef(lhs, field);
    }

    public static FieldRef ref(Expression lhs, String field) {
        return new FieldRef(lhs, field);
    }

    public static FieldRef refthis(String field) {
        return new FieldRef(null, field, true);
    }

    public static Expression dotclass(final TypeReference cl) {
        return new AbstractExpression(){

            public void generate(Formatter f) {
                TypeReference c = cl instanceof NarrowedClass ? ((NarrowedClass)cl).basis : cl;
                f.g(c).p(".class");
            }
        };
    }

    public static ArrayCompRef component(Expression lhs, Expression index) {
        return new ArrayCompRef(lhs, index);
    }

    public static Cast cast(Type type, Expression expr) {
        return new Cast(type, expr);
    }

    public static JArray newArray(Type type) {
        return ExpressionFactory.newArray(type, null);
    }

    public static JArray newArray(Type type, Expression size) {
        return new JArray(type.erasure(), size);
    }

    public static JArray newArray(Type type, int size) {
        return ExpressionFactory.newArray(type, ExpressionFactory.lit(size));
    }

    public static Expression _this() {
        return __this;
    }

    public static Expression _super() {
        return __super;
    }

    public static Expression _null() {
        return __null;
    }

    public static Expression lit(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static Expression lit(int n) {
        return new Atom(Integer.toString(n));
    }

    public static Expression lit(long n) {
        return new Atom(Long.toString(n) + "L");
    }

    public static Expression lit(float f) {
        if (f == Float.NEGATIVE_INFINITY) {
            return new Atom("java.lang.Float.NEGATIVE_INFINITY");
        }
        if (f == Float.POSITIVE_INFINITY) {
            return new Atom("java.lang.Float.POSITIVE_INFINITY");
        }
        if (Float.isNaN(f)) {
            return new Atom("java.lang.Float.NaN");
        }
        return new Atom(Float.toString(f) + "F");
    }

    public static Expression lit(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return new Atom("java.lang.Double.NEGATIVE_INFINITY");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return new Atom("java.lang.Double.POSITIVE_INFINITY");
        }
        if (Double.isNaN(d)) {
            return new Atom("java.lang.Double.NaN");
        }
        return new Atom(Double.toString(d) + "D");
    }

    public static String quotify(char quote, String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n + 2);
        sb.append(quote);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int j = charEscape.indexOf(c);
            if (j >= 0) {
                if (quote == '\"' && c == '\'' || quote == '\'' && c == '\"') {
                    sb.append(c);
                    continue;
                }
                sb.append('\\');
                sb.append(charMacro.charAt(j));
                continue;
            }
            if (c < ' ' || '~' < c) {
                sb.append("\\u");
                String hex = Integer.toHexString(c & 0xFFFF);
                for (int k = hex.length(); k < 4; ++k) {
                    sb.append('0');
                }
                sb.append(hex);
                continue;
            }
            sb.append(c);
        }
        sb.append(quote);
        return sb.toString();
    }

    public static Expression lit(char c) {
        return new Atom(ExpressionFactory.quotify('\'', "" + c));
    }

    public static Expression lit(String s) {
        return new StringLiteral(s);
    }

    public static Expression direct(final String source) {
        return new AbstractExpression(){

            public void generate(Formatter f) {
                f.p('(').p(source).p(')');
            }
        };
    }
}

