/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.model.code.AbstractExpression;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Type;

public final class JArray
extends AbstractExpression {
    private final Type type;
    private final Expression size;
    private List<Expression> exprs = null;

    public JArray add(Expression e) {
        if (this.exprs == null) {
            this.exprs = new ArrayList<Expression>();
        }
        this.exprs.add(e);
        return this;
    }

    JArray(Type type, Expression size) {
        this.type = type;
        this.size = size;
    }

    public void generate(Formatter f) {
        int arrayCount = 0;
        Type t = this.type;
        while (t.isArray()) {
            t = t.elementType();
            ++arrayCount;
        }
        f.p("new").g(t).p('[');
        if (this.size != null) {
            f.g(this.size);
        }
        f.p(']');
        for (int i = 0; i < arrayCount; ++i) {
            f.p("[]");
        }
        if (this.size == null || this.exprs != null) {
            f.p('{');
        }
        if (this.exprs != null) {
            f.g(this.exprs);
        } else {
            f.p(' ');
        }
        if (this.size == null || this.exprs != null) {
            f.p('}');
        }
    }
}

