/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code.builders;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBuilder {
    private DefinedClass targetClass;
    private Class<?> type;
    private Type typeRef;
    private String name;
    private String javadoc;
    private boolean getter;
    private boolean setter;
    private int modifiers;
    private Object initialValue;

    public static FieldBuilder newConstantFieldBuilder(DefinedClass targetClass) {
        FieldBuilder fieldBuilder = new FieldBuilder(targetClass);
        fieldBuilder.privateVisibility();
        fieldBuilder.staticField();
        fieldBuilder.finalField();
        return fieldBuilder;
    }

    public static FieldVariable newLoggerField(DefinedClass targetClass) {
        return new FieldBuilder(targetClass).privateVisibility().staticField().finalField().name("LOGGER").type(Logger.class).initialValue(targetClass.owner().ref(Logger.class).staticInvoke("getLogger").arg(ExpressionFactory.dotclass(targetClass))).build();
    }

    public FieldBuilder(DefinedClass targetClass) {
        Validate.notNull((Object)targetClass, (String)"the target class cannot be null");
        this.targetClass = targetClass;
        this.privateVisibility();
    }

    public FieldBuilder name(String name) {
        this.name = name;
        return this;
    }

    public FieldBuilder type(Class<?> type) {
        this.type = type;
        return this;
    }

    public FieldBuilder type(Type typeRef) {
        this.typeRef = typeRef;
        return this;
    }

    public FieldBuilder javadoc(String javadoc) {
        this.javadoc = javadoc;
        return this;
    }

    public FieldBuilder privateVisibility() {
        this.modifiers |= 4;
        return this;
    }

    public FieldBuilder getterAndSetter() {
        this.getter = true;
        this.setter = true;
        return this;
    }

    public FieldBuilder getter() {
        this.getter = true;
        return this;
    }

    public FieldBuilder setter() {
        this.setter = true;
        return this;
    }

    public FieldBuilder staticField() {
        this.modifiers |= 0x10;
        return this;
    }

    public FieldBuilder finalField() {
        this.modifiers |= 8;
        return this;
    }

    public FieldBuilder initialValue(Expression initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    public FieldBuilder initialValue(String initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    public FieldBuilder initialValue(int initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    private Method generateSetter(FieldVariable field) {
        Method setter = this.targetClass.method(1, this.targetClass.owner().VOID, "set" + StringUtils.capitalize((String)field.name()));
        setter.javadoc().add("Sets " + field.name());
        setter.javadoc().addParam("value Value to set");
        Variable value = setter.param(field.type(), "value");
        setter.body().assign(ExpressionFactory._this().ref(field), value);
        return setter;
    }

    private Method generateGetter(FieldVariable field) {
        Method setter = this.targetClass.method(1, field.type(), "get" + StringUtils.capitalize((String)field.name()));
        setter.javadoc().add("Retrieves " + field.name());
        setter.body()._return(ExpressionFactory._this().ref(field));
        return setter;
    }

    public FieldVariable build() {
        Validate.notNull((Object)this.name, (String)"The name must be set");
        if (this.typeRef == null) {
            this.typeRef = this.targetClass.owner().ref(this.type);
        }
        FieldVariable field = this.targetClass.field(this.modifiers, this.typeRef, this.name);
        if (this.javadoc != null && !this.javadoc.isEmpty()) {
            field.javadoc().add(this.javadoc);
        }
        if (this.getter) {
            this.generateGetter(field);
        }
        if (this.setter) {
            this.generateSetter(field);
        }
        if (this.initialValue != null) {
            if (this.initialValue instanceof Expression) {
                field.init((Expression)this.initialValue);
            } else if (this.initialValue instanceof String) {
                field.init(ExpressionFactory.lit((String)this.initialValue));
            } else {
                field.init(ExpressionFactory.lit((Integer)this.initialValue));
            }
        }
        return field;
    }
}

