/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.mule.devkit.model.code.AbstractGenerifiable;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationUse;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.ClassContainer;
import org.mule.devkit.model.code.ClassType;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.DocComment;
import org.mule.devkit.model.code.DocCommentable;
import org.mule.devkit.model.code.EnumConstant;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generifiable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.TypedAnnotationWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedClass
extends TypeReference
implements Declaration,
ClassContainer,
Generifiable,
Annotable,
DocCommentable {
    private String name;
    private Modifiers mods;
    private TypeReference superClass;
    private final Set<TypeReference> interfaces = new TreeSet<TypeReference>();
    final Map<String, FieldVariable> fields = new LinkedHashMap<String, FieldVariable>();
    private Block init;
    private DocComment jdoc;
    private final List<Method> constructors = new ArrayList<Method>();
    private final List<Method> methods = new ArrayList<Method>();
    private Map<String, DefinedClass> classes;
    private boolean hideFile;
    public Object metadata;
    private String directBlock;
    private ClassContainer outer;
    private final ClassType classType;
    private final Map<String, EnumConstant> enumConstantsByName = new LinkedHashMap<String, EnumConstant>();
    private List<AnnotationUse> annotations;
    private final AbstractGenerifiable generifiable = new AbstractGenerifiable(){

        protected CodeModel owner() {
            return DefinedClass.this.owner();
        }
    };

    DefinedClass(ClassContainer parent, int mods, String name, ClassType classTypeval) {
        this(mods, name, parent, parent.owner(), classTypeval);
    }

    DefinedClass(CodeModel owner, int mods, String name) {
        this(mods, name, null, owner);
    }

    private DefinedClass(int mods, String name, ClassContainer parent, CodeModel owner) {
        this(mods, name, parent, owner, ClassType.CLASS);
    }

    private DefinedClass(int mods, String name, ClassContainer parent, CodeModel owner, ClassType classTypeVal) {
        super(owner);
        if (name != null) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException("TypeReference name empty");
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                String msg = "TypeReference name " + name + " contains illegal character" + " for beginning of identifier: " + name.charAt(0);
                throw new IllegalArgumentException(msg);
            }
            for (int i = 1; i < name.length(); ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                String msg = "TypeReference name " + name + " contains illegal character " + name.charAt(i);
                throw new IllegalArgumentException(msg);
            }
        }
        this.classType = classTypeVal;
        this.mods = this.isInterface() ? Modifiers.forInterface(mods) : Modifiers.forClass(mods);
        this.name = name;
        this.outer = parent;
    }

    public final boolean isAnonymous() {
        return this.name == null;
    }

    public DefinedClass _extends(TypeReference superClass) {
        if (this.classType == ClassType.INTERFACE) {
            if (superClass.isInterface()) {
                return this._implements(superClass);
            }
            throw new IllegalArgumentException("unable to set the super class for an interface");
        }
        if (superClass == null) {
            throw new NullPointerException();
        }
        for (TypeReference o = superClass.outer(); o != null; o = o.outer()) {
            if (this != o) continue;
            throw new IllegalArgumentException("Illegal class inheritance loop.  Outer class " + this.name + " may not subclass from inner class: " + o.name());
        }
        this.superClass = superClass;
        return this;
    }

    public DefinedClass _extends(Class<?> superClass) {
        return this._extends(this.owner().ref(superClass));
    }

    @Override
    public TypeReference _extends() {
        if (this.superClass == null) {
            this.superClass = this.owner().ref(Object.class);
        }
        return this.superClass;
    }

    public DefinedClass _implements(TypeReference iface) {
        this.interfaces.add(iface);
        return this;
    }

    public DefinedClass _implements(Class<?> iface) {
        return this._implements(this.owner().ref(iface));
    }

    @Override
    public Iterator<TypeReference> _implements() {
        return this.interfaces.iterator();
    }

    @Override
    public String name() {
        return this.name;
    }

    public EnumConstant enumConstant(String name) {
        EnumConstant ec = this.enumConstantsByName.get(name);
        if (null == ec) {
            ec = new EnumConstant(this, name);
            this.enumConstantsByName.put(name, ec);
        }
        return ec;
    }

    @Override
    public String fullName() {
        if (this.outer instanceof DefinedClass) {
            return ((DefinedClass)this.outer).fullName() + '.' + this.name();
        }
        Package p = this._package();
        if (p.isUnnamed()) {
            return this.name();
        }
        return p.name() + '.' + this.name();
    }

    @Override
    public String binaryName() {
        if (this.outer instanceof DefinedClass) {
            return ((DefinedClass)this.outer).binaryName() + '$' + this.name();
        }
        return this.fullName();
    }

    @Override
    public boolean isInterface() {
        return this.classType == ClassType.INTERFACE;
    }

    @Override
    public boolean isAbstract() {
        return this.mods.isAbstract();
    }

    public FieldVariable field(int mods, Type type, String name) {
        return this.field(mods, type, name, null);
    }

    public FieldVariable field(int mods, Class<?> type, String name) {
        return this.field(mods, this.owner()._ref(type), name);
    }

    public FieldVariable field(int mods, Type type, String name, Expression init) {
        FieldVariable f = new FieldVariable(this, Modifiers.forField(mods), type, name, init);
        if (this.fields.containsKey(name)) {
            throw new IllegalArgumentException("trying to create the same field twice: " + name);
        }
        this.fields.put(name, f);
        return f;
    }

    public boolean isAnnotationTypeDeclaration() {
        return this.classType == ClassType.ANNOTATION_TYPE_DECL;
    }

    @Override
    public DefinedClass _annotationTypeDeclaration(String name) throws ClassAlreadyExistsException {
        return this._class(1, name, ClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    public DefinedClass _enum(String name) throws ClassAlreadyExistsException {
        return this._class(1, name, ClassType.ENUM);
    }

    public DefinedClass _enum(int mods, String name) throws ClassAlreadyExistsException {
        return this._class(mods, name, ClassType.ENUM);
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public FieldVariable field(int mods, Class<?> type, String name, Expression init) {
        return this.field(mods, this.owner()._ref(type), name, init);
    }

    public Map<String, FieldVariable> fields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public void removeField(FieldVariable field) {
        if (this.fields.remove(field.name()) != field) {
            throw new IllegalArgumentException();
        }
    }

    public Block init() {
        if (this.init == null) {
            this.init = new Block();
        }
        return this.init;
    }

    public Method constructor(int mods) {
        Method c = new Method(mods, this);
        this.constructors.add(c);
        return c;
    }

    public Iterator<Method> constructors() {
        return this.constructors.iterator();
    }

    public Method getConstructor(Type[] argTypes) {
        for (Method m : this.constructors) {
            if (!m.hasSignature(argTypes)) continue;
            return m;
        }
        return null;
    }

    public Method method(int mods, Type type, String name) {
        Method m = new Method(this, mods, type, name);
        this.methods.add(m);
        return m;
    }

    public Method method(int mods, Class<?> type, String name) {
        return this.method(mods, this.owner()._ref(type), name);
    }

    public Method method(int mods, Class<?> type, Class<?> narrowedType, String name) {
        return this.method(mods, this.owner()._ref(type).boxify().narrow(narrowedType), name);
    }

    public Collection<Method> methods() {
        return this.methods;
    }

    public Method getMethod(String name, Type[] argTypes) {
        for (Method m : this.methods) {
            if (!m.name().equals(name) || !m.hasSignature(argTypes)) continue;
            return m;
        }
        return null;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isPackage() {
        return false;
    }

    @Override
    public Package getPackage() {
        return this.parentContainer().getPackage();
    }

    @Override
    public DefinedClass _class(int mods, String name) throws ClassAlreadyExistsException {
        return this._class(mods, name, ClassType.CLASS);
    }

    @Override
    public DefinedClass _class(int mods, String name, boolean isInterface) throws ClassAlreadyExistsException {
        return this._class(mods, name, isInterface ? ClassType.INTERFACE : ClassType.CLASS);
    }

    @Override
    public DefinedClass _class(int mods, String name, ClassType classTypeVal) throws ClassAlreadyExistsException {
        String NAME = CodeModel.isCaseSensitiveFileSystem ? name.toUpperCase() : name;
        if (this.getClasses().containsKey(NAME)) {
            throw new ClassAlreadyExistsException(this.getClasses().get(NAME));
        }
        DefinedClass c = new DefinedClass(this, mods, name, classTypeVal);
        this.getClasses().put(NAME, c);
        return c;
    }

    @Override
    public DefinedClass _class(String name) {
        try {
            return this._class(1, name);
        }
        catch (ClassAlreadyExistsException caee) {
            return caee.getExistingClass();
        }
    }

    @Override
    public DefinedClass _interface(int mods, String name) throws ClassAlreadyExistsException {
        return this._class(mods, name, ClassType.INTERFACE);
    }

    @Override
    public DefinedClass _interface(String name) throws ClassAlreadyExistsException {
        return this._interface(1, name);
    }

    @Override
    public DocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new DocComment(this.owner());
        }
        return this.jdoc;
    }

    public void hide() {
        this.hideFile = true;
    }

    public boolean isHidden() {
        return this.hideFile;
    }

    @Override
    public final Iterator<DefinedClass> classes() {
        if (this.classes == null) {
            return Collections.emptyList().iterator();
        }
        return this.classes.values().iterator();
    }

    private Map<String, DefinedClass> getClasses() {
        if (this.classes == null) {
            this.classes = new TreeMap<String, DefinedClass>();
        }
        return this.classes;
    }

    public final TypeReference[] listClasses() {
        if (this.classes == null) {
            return new TypeReference[0];
        }
        return this.classes.values().toArray(new TypeReference[this.classes.values().size()]);
    }

    @Override
    public TypeReference outer() {
        if (this.outer.isClass()) {
            return (TypeReference)((Object)this.outer);
        }
        return null;
    }

    @Override
    public void declare(Formatter f) {
        if (this.jdoc != null) {
            f.nl().g(this.jdoc);
        }
        if (this.annotations != null) {
            for (AnnotationUse annotation : this.annotations) {
                f.g(annotation).nl();
            }
        }
        f.g(this.mods).p(this.classType.declarationToken).id(this.name).d(this.generifiable);
        if (this.superClass != null && this.superClass != this.owner().ref(Object.class)) {
            f.nl().i().p("extends").g(this.superClass).nl().o();
        }
        if (!this.interfaces.isEmpty()) {
            if (this.superClass == null) {
                f.nl();
            }
            f.i().p(this.classType == ClassType.INTERFACE ? "extends" : "implements");
            f.g(this.interfaces);
            f.nl().o();
        }
        this.declareBody(f);
    }

    protected void declareBody(Formatter f) {
        f.p('{').nl().nl().i();
        boolean first = true;
        if (!this.enumConstantsByName.isEmpty()) {
            for (EnumConstant c : this.enumConstantsByName.values()) {
                if (!first) {
                    f.p(',').nl();
                }
                f.d(c);
                first = false;
            }
            f.p(';').nl();
        }
        for (FieldVariable field : this.fields.values()) {
            f.d(field);
        }
        if (this.init != null) {
            f.nl().p("static").s(this.init);
        }
        for (Method m : this.constructors) {
            f.nl().d(m);
        }
        for (Method m : this.methods) {
            f.nl().d(m);
        }
        if (this.classes != null) {
            for (DefinedClass dc : this.classes.values()) {
                f.nl().d(dc);
            }
        }
        if (this.directBlock != null) {
            f.p(this.directBlock);
        }
        f.nl().o().p('}').nl();
    }

    public void direct(String string) {
        this.directBlock = this.directBlock == null ? string : this.directBlock + string;
    }

    @Override
    public final Package _package() {
        ClassContainer p = this.outer;
        while (!(p instanceof Package)) {
            p = p.parentContainer();
        }
        return (Package)p;
    }

    @Override
    public final ClassContainer parentContainer() {
        return this.outer;
    }

    @Override
    public TypeVariable generify(String name) {
        return this.generifiable.generify(name);
    }

    @Override
    public TypeVariable generify(String name, Class<?> bound) {
        return this.generifiable.generify(name, bound);
    }

    @Override
    public TypeVariable generify(String name, TypeReference bound) {
        return this.generifiable.generify(name, bound);
    }

    @Override
    public TypeVariable[] typeParams() {
        return this.generifiable.typeParams();
    }

    @Override
    protected TypeReference substituteParams(TypeVariable[] variables, List<TypeReference> bindings) {
        return this;
    }

    @Override
    public AnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Override
    public AnnotationUse annotate(TypeReference clazz) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationUse>();
        }
        AnnotationUse a = new AnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public <W extends AnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<AnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationUse>();
        }
        return Collections.unmodifiableCollection(this.annotations);
    }

    public Modifiers mods() {
        return this.mods;
    }

    @Override
    public String toString() {
        return "DefinedClass{name='" + this.name + '\'' + '}';
    }
}

