/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;

public class TryStatement
implements Statement {
    private Block body = new Block();
    private List<CatchBlock> catches = new ArrayList<CatchBlock>();
    private Block _finally = null;

    TryStatement() {
    }

    public Block body() {
        return this.body;
    }

    public CatchBlock _catch(TypeReference exception) {
        CatchBlock cb = new CatchBlock(exception);
        this.catches.add(cb);
        return cb;
    }

    public Block _finally() {
        if (this._finally == null) {
            this._finally = new Block();
        }
        return this._finally;
    }

    public void state(Formatter f) {
        f.p("try").g(this.body);
        for (CatchBlock cb : this.catches) {
            f.g(cb);
        }
        if (this._finally != null) {
            f.p("finally").g(this._finally);
        }
        f.nl();
    }
}

