/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.model.code.Assignment;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.BreakStatement;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.ContinueStatement;
import org.mule.devkit.model.code.Declaration;
import org.mule.devkit.model.code.DoLoop;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ForEach;
import org.mule.devkit.model.code.ForLoop;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Generable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Label;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.ReturnStatement;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.SwitchStatement;
import org.mule.devkit.model.code.ThrowStatement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.WhileLoop;

public final class Block
implements Generable,
Statement {
    private final List<Object> content = new ArrayList<Object>();
    private boolean bracesRequired = true;
    private boolean indentRequired = true;
    private int pos;

    public Block() {
        this(true, true);
    }

    public Block(boolean bracesRequired, boolean indentRequired) {
        this.bracesRequired = bracesRequired;
        this.indentRequired = indentRequired;
    }

    public List<Object> getContents() {
        return Collections.unmodifiableList(this.content);
    }

    private <T> T insert(T statementOrDeclaration) {
        this.content.add(this.pos, statementOrDeclaration);
        ++this.pos;
        return statementOrDeclaration;
    }

    public int pos() {
        return this.pos;
    }

    public int pos(int newPos) {
        int r = this.pos;
        if (newPos > this.content.size() || newPos < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = newPos;
        return r;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public Variable decl(Type type, String name) {
        return this.decl(0, type, name, null);
    }

    public Variable decl(Type type, String name, Expression init) {
        return this.decl(0, type, name, init);
    }

    public Variable decl(int mods, Type type, String name, Expression init) {
        Variable v = new Variable(Modifiers.forVar(mods), type, name, init);
        this.insert(v);
        this.bracesRequired = true;
        this.indentRequired = true;
        return v;
    }

    public Block assign(AssignmentTarget lhs, Expression exp) {
        this.insert(new Assignment(lhs, exp));
        return this;
    }

    public Block assignPlus(AssignmentTarget lhs, Expression exp) {
        this.insert(new Assignment(lhs, exp, "+"));
        return this;
    }

    public Invocation invoke(Expression expr, String method) {
        Invocation i = new Invocation(expr, method);
        this.insert(i);
        return i;
    }

    public Invocation invoke(Expression expr, Method method) {
        return this.insert(new Invocation(expr, method));
    }

    public Invocation staticInvoke(TypeReference type, String method) {
        return this.insert(new Invocation(type, method));
    }

    public Invocation invoke(String method) {
        return this.insert(new Invocation((Expression)null, method));
    }

    public Invocation invoke(Method method) {
        return this.insert(new Invocation((Expression)null, method));
    }

    public Block add(Statement s) {
        this.insert(s);
        return this;
    }

    public Conditional _if(Expression expr) {
        return this.insert(new Conditional(expr));
    }

    public ForLoop _for() {
        return this.insert(new ForLoop());
    }

    public WhileLoop _while(Expression test) {
        return this.insert(new WhileLoop(test));
    }

    public SwitchStatement _switch(Expression test) {
        return this.insert(new SwitchStatement(test));
    }

    public DoLoop _do(Expression test) {
        return this.insert(new DoLoop(test));
    }

    public TryStatement _try() {
        return this.insert(new TryStatement());
    }

    public void _return() {
        this.insert(new ReturnStatement(null));
    }

    public void _return(Expression exp) {
        this.insert(new ReturnStatement(exp));
    }

    public void _throw(Expression exp) {
        this.insert(new ThrowStatement(exp));
    }

    public void _break() {
        this._break(null);
    }

    public void _break(Label label) {
        this.insert(new BreakStatement(label));
    }

    public Label label(String name) {
        Label l = new Label(name);
        this.insert(l);
        return l;
    }

    public void _continue(Label label) {
        this.insert(new ContinueStatement(label));
    }

    public void _continue() {
        this._continue(null);
    }

    public Block block() {
        Block b = new Block();
        b.bracesRequired = false;
        b.indentRequired = false;
        return this.insert(b);
    }

    public Statement directStatement(final String source) {
        Statement s = new Statement(){

            @Override
            public void state(Formatter f) {
                f.p(source).nl();
            }
        };
        this.add(s);
        return s;
    }

    @Override
    public void generate(Formatter f) {
        if (this.bracesRequired) {
            f.p('{').nl();
        }
        if (this.indentRequired) {
            f.i();
        }
        this.generateBody(f);
        if (this.indentRequired) {
            f.o();
        }
        if (this.bracesRequired) {
            f.p('}');
        }
    }

    void generateBody(Formatter f) {
        for (Object o : this.content) {
            if (o instanceof Declaration) {
                f.d((Declaration)o);
                continue;
            }
            f.s((Statement)o);
        }
    }

    public ForEach forEach(Type varType, String name, Expression collection) {
        return this.insert(new ForEach(varType, name, collection));
    }

    @Override
    public void state(Formatter f) {
        f.g(this);
        if (this.bracesRequired) {
            f.nl();
        }
    }
}

