/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.DocComment;
import org.mule.devkit.model.code.DocCommentable;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.Variable;

public class FieldVariable
extends Variable
implements DocCommentable {
    private DocComment jdoc = null;
    private final DefinedClass owner;

    FieldVariable(DefinedClass owner, Modifiers mods, Type type, String name, Expression init) {
        super(mods, type, name, init);
        this.owner = owner;
    }

    @Override
    public void name(String name) {
        if (this.owner.fields.containsKey(name)) {
            throw new IllegalArgumentException("name " + name + " is already in use");
        }
        String oldName = this.name();
        super.name(name);
        this.owner.fields.remove(oldName);
        this.owner.fields.put(name, this);
    }

    @Override
    public DocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new DocComment(this.owner.owner());
        }
        return this.jdoc;
    }

    @Override
    public void declare(Formatter f) {
        if (this.jdoc != null) {
            f.g(this.jdoc);
        }
        super.declare(f);
    }

    public String toString() {
        return "FieldVariable{jdoc=" + this.jdoc + ", owner=" + this.owner + '}';
    }
}

