/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Modifiers;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.Variable;

public class ForLoop
implements Statement {
    private List<Object> inits = new ArrayList<Object>();
    private Expression test = null;
    private List<Expression> updates = new ArrayList<Expression>();
    private Block body = null;

    public Variable init(int mods, Type type, String var, Expression e) {
        Variable v = new Variable(Modifiers.forVar(mods), type, var, e);
        this.inits.add(v);
        return v;
    }

    public Variable init(Type type, String var, Expression e) {
        return this.init(0, type, var, e);
    }

    public void init(Variable v, Expression e) {
        this.inits.add(ExpressionFactory.assign(v, e));
    }

    public void test(Expression e) {
        this.test = e;
    }

    public void update(Expression e) {
        this.updates.add(e);
    }

    public Block body() {
        if (this.body == null) {
            this.body = new Block();
        }
        return this.body;
    }

    @Override
    public void state(Formatter f) {
        f.p("for (");
        boolean first = true;
        for (Object o : this.inits) {
            if (!first) {
                f.p(',');
            }
            if (o instanceof Variable) {
                f.b((Variable)o);
            } else {
                f.g((Expression)o);
            }
            first = false;
        }
        f.p(';').g(this.test).p(';').g(this.updates).p(')');
        if (this.body != null) {
            f.g(this.body).nl();
        } else {
            f.p(';').nl();
        }
    }
}

