/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.mule.devkit.model.code.Annotable;
import org.mule.devkit.model.code.AnnotationArrayMember;
import org.mule.devkit.model.code.AnnotationUse;
import org.mule.devkit.model.code.AnnotationWriter;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.Type;

class TypedAnnotationWriter<A extends Annotation, W extends AnnotationWriter<A>>
implements InvocationHandler,
AnnotationWriter<A> {
    private final AnnotationUse use;
    private final Class<A> annotation;
    private final Class<W> writerType;
    private Map<String, AnnotationArrayMember> arrays;

    public TypedAnnotationWriter(Class<A> annotation, Class<W> writer, AnnotationUse use) {
        this.annotation = annotation;
        this.writerType = writer;
        this.use = use;
    }

    @Override
    public AnnotationUse getAnnotationUse() {
        return this.use;
    }

    @Override
    public Class<A> getAnnotationType() {
        return this.annotation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method m;
        Class<?> rt;
        if (method.getDeclaringClass() == AnnotationWriter.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        String name = method.getName();
        Object arg = null;
        if (args != null && args.length > 0) {
            arg = args[0];
        }
        if ((rt = (m = this.annotation.getDeclaredMethod(name, new Class[0])).getReturnType()).isArray()) {
            return this.addArrayValue(proxy, name, rt.getComponentType(), method.getReturnType(), arg);
        }
        if (Annotation.class.isAssignableFrom(rt)) {
            Class<?> r = rt;
            return super.createProxy();
        }
        if (arg instanceof Type) {
            Type targ = (Type)arg;
            this.checkType(Class.class, rt);
            if (m.getDefaultValue() != null && targ.equals(targ.owner().ref((Class)m.getDefaultValue()))) {
                return proxy;
            }
            this.use.param(name, targ);
            return proxy;
        }
        this.checkType(arg.getClass(), rt);
        if (m.getDefaultValue() != null && m.getDefaultValue().equals(arg)) {
            return proxy;
        }
        if (arg instanceof String) {
            this.use.param(name, (String)arg);
            return proxy;
        }
        if (arg instanceof Boolean) {
            this.use.param(name, (Boolean)arg);
            return proxy;
        }
        if (arg instanceof Integer) {
            this.use.param(name, (Integer)arg);
            return proxy;
        }
        if (arg instanceof Class) {
            this.use.param(name, (Class)arg);
            return proxy;
        }
        if (arg instanceof Enum) {
            this.use.param(name, (Enum)arg);
            return proxy;
        }
        throw new IllegalArgumentException("Unable to handle this method call " + method.toString());
    }

    private Object addArrayValue(Object proxy, String name, Class itemType, Class expectedReturnType, Object arg) {
        AnnotationArrayMember m;
        if (this.arrays == null) {
            this.arrays = new HashMap<String, AnnotationArrayMember>();
        }
        if ((m = this.arrays.get(name)) == null) {
            m = this.use.paramArray(name);
            this.arrays.put(name, m);
        }
        if (Annotation.class.isAssignableFrom(itemType)) {
            Class r = itemType;
            if (!AnnotationWriter.class.isAssignableFrom(expectedReturnType)) {
                throw new IllegalArgumentException("Unexpected return type " + expectedReturnType);
            }
            return super.createProxy();
        }
        if (arg instanceof Type) {
            this.checkType(Class.class, itemType);
            m.param((Type)arg);
            return proxy;
        }
        this.checkType(arg.getClass(), itemType);
        if (arg instanceof String) {
            m.param((String)arg);
            return proxy;
        }
        if (arg instanceof Boolean) {
            m.param((Boolean)arg);
            return proxy;
        }
        if (arg instanceof Integer) {
            m.param((Integer)arg);
            return proxy;
        }
        if (arg instanceof Class) {
            m.param((Class)arg);
            return proxy;
        }
        throw new IllegalArgumentException("Unable to handle this method call ");
    }

    private void checkType(Class<?> actual, Class<?> expected) {
        if (expected == actual || expected.isAssignableFrom(actual)) {
            return;
        }
        if (expected == CodeModel.boxToPrimitive.get(actual)) {
            return;
        }
        throw new IllegalArgumentException("Expected " + expected + " but found " + actual);
    }

    private W createProxy() {
        return (W)((AnnotationWriter)Proxy.newProxyInstance(this.writerType.getClassLoader(), new Class[]{this.writerType}, (InvocationHandler)this));
    }

    static <W extends AnnotationWriter<?>> W create(Class<W> w, Annotable annotatable) {
        Class<Annotation> a = TypedAnnotationWriter.findAnnotationType(w);
        return super.createProxy();
    }

    private static Class<? extends Annotation> findAnnotationType(Class<?> clazz) {
        for (java.lang.reflect.Type t : clazz.getGenericInterfaces()) {
            Class<Annotation> r;
            ParameterizedType p;
            if (t instanceof ParameterizedType && (p = (ParameterizedType)t).getRawType() == AnnotationWriter.class) {
                return (Class)p.getActualTypeArguments()[0];
            }
            if (!(t instanceof Class) || (r = TypedAnnotationWriter.findAnnotationType((Class)t)) == null) continue;
            return r;
        }
        return null;
    }
}

