/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.code;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.Formatter;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;

final class ArrayClass
extends TypeReference {
    private final Type componentType;
    private int size;

    ArrayClass(CodeModel owner, Type component) {
        super(owner);
        this.componentType = component;
    }

    @Override
    public String name() {
        return this.componentType.name() + "[]";
    }

    @Override
    public String fullName() {
        return this.componentType.fullName() + "[]";
    }

    @Override
    public String binaryName() {
        return this.componentType.binaryName() + "[]";
    }

    @Override
    public void generate(Formatter f) {
        f.g(this.componentType).p("[]");
    }

    @Override
    public Package _package() {
        return this.owner().rootPackage();
    }

    @Override
    public TypeReference _extends() {
        return this.owner().ref(Object.class);
    }

    @Override
    public Iterator<TypeReference> _implements() {
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public Type elementType() {
        return this.componentType;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayClass)) {
            return false;
        }
        return this.componentType.equals(((ArrayClass)obj).componentType);
    }

    @Override
    public int hashCode() {
        return this.componentType.hashCode();
    }

    @Override
    protected TypeReference substituteParams(TypeVariable[] variables, List<TypeReference> bindings) {
        if (this.componentType.isPrimitive()) {
            return this;
        }
        TypeReference c = ((TypeReference)this.componentType).substituteParams(variables, bindings);
        if (c == this.componentType) {
            return this;
        }
        return new ArrayClass(this.owner(), c);
    }
}

