/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.data.Data;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.doclet.Doclava;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearPage {
    private static ArrayList<String> mTemplateDirs = new ArrayList();
    private static boolean mTemplateDirSet = false;
    private static ArrayList<String> mBundledTemplateDirs = new ArrayList();
    public static String outputDir = "docs";
    public static List<String> htmlDirs = new ArrayList<String>();
    public static String toroot = null;

    public static String getPathToRoot(String path) {
        String toroot = "";
        if (ClearPage.toroot != null) {
            toroot = ClearPage.toroot;
        } else {
            int slashcount = ClearPage.countSlashes(path);
            if (slashcount > 0) {
                for (int i = 0; i < slashcount; ++i) {
                    toroot = toroot + "../";
                }
            } else {
                toroot = "./";
            }
        }
        return toroot;
    }

    public static void addTemplateDir(String dir) {
        mTemplateDirSet = true;
        mTemplateDirs.add(dir);
    }

    public static List<String> getTemplateDirs() {
        return mTemplateDirs;
    }

    public static void addBundledTemplateDir(String dir) {
        mTemplateDirSet = true;
        mBundledTemplateDirs.add(dir);
    }

    public static List<String> getBundledTemplateDirs() {
        return mBundledTemplateDirs;
    }

    private static int countSlashes(String s) {
        int N = s.length();
        int slashcount = 0;
        for (int i = 0; i < N; ++i) {
            if (s.charAt(i) != '/') continue;
            ++slashcount;
        }
        return slashcount;
    }

    public static void write(Data data, String templ, String filename, JSilver cs) {
        ClearPage.write(data, templ, filename, false, cs);
    }

    public static void write(Data data, String templ, String filename) {
        ClearPage.write(data, templ, filename, false, Doclava.jSilver);
    }

    public static void write(Data data, String templ, String filename, boolean fullPath) {
        ClearPage.write(data, templ, filename, fullPath, Doclava.jSilver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Data data, String templ, String filename, boolean fullPath, JSilver cs) {
        if (!htmlDirs.isEmpty()) {
            data.setValue("hasindex", "true");
        }
        String rootPath = ClearPage.getPathToRoot(filename);
        data.setValue("toroot", rootPath);
        data.setValue("toassets", rootPath + Doclava.assetsOutputDir + "/");
        data.setValue("filename", filename);
        if (!fullPath) {
            filename = outputDir + "/" + filename;
        }
        int i = 0;
        if (!htmlDirs.isEmpty()) {
            for (String dir : htmlDirs) {
                data.setValue("hdf.loadpaths." + i, dir);
                ++i;
            }
        }
        if (mTemplateDirSet) {
            for (String dir : mTemplateDirs) {
                data.setValue("hdf.loadpaths." + i, dir);
                ++i;
            }
        } else {
            data.setValue("hdf.loadpaths." + i, "templates");
        }
        File file = new File(ClearPage.outputFilename(filename));
        ClearPage.ensureDirectory(file);
        OutputStreamWriter stream = null;
        try {
            stream = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            String rendered = cs.render(templ, data);
            stream.write(rendered, 0, rendered.length());
        }
        catch (IOException e) {
            System.out.println("error: " + e.getMessage() + "; when writing file: " + filename);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void ensureDirectory(File f) {
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public static void copyFile(File from, File to) {
        FileOutputStream out;
        FileInputStream in;
        try {
            if (!from.exists()) {
                throw new IOException();
            }
            in = new FileInputStream(from);
        }
        catch (IOException e) {
            System.err.println(from.getAbsolutePath() + ": Error opening file");
            return;
        }
        ClearPage.ensureDirectory(to);
        try {
            out = new FileOutputStream(to);
        }
        catch (IOException e) {
            System.err.println(from.getAbsolutePath() + ": Error opening file");
            return;
        }
        long sizel = from.length();
        int maxsize = 65536;
        int size = sizel > 65536L ? 65536 : (int)sizel;
        byte[] buf = new byte[size];
        while (true) {
            try {
                size = in.read(buf);
            }
            catch (IOException e) {
                System.err.println(from.getAbsolutePath() + ": error reading file");
                break;
            }
            if (size <= 0) break;
            try {
                out.write(buf, 0, size);
            }
            catch (IOException e) {
                System.err.println(from.getAbsolutePath() + ": error writing file");
            }
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static String outputFilename(String htmlFile) {
        if (!Doclava.htmlExtension.equals(".html") && htmlFile.endsWith(".html")) {
            return htmlFile.substring(0, htmlFile.length() - 5) + Doclava.htmlExtension;
        }
        return htmlFile;
    }
}

