/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.devkit.doclet.ContainerInfo;
import org.mule.devkit.doclet.ParsedTagInfo;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;

public class ParamTagInfo
extends ParsedTagInfo {
    static final Pattern PATTERN = Pattern.compile("([^ \t\r\n]+)[ \t\r\n]+(.*)", 32);
    private boolean mIsTypeParameter;
    private String mParameterComment;
    private String mParameterName;
    private boolean mIsOptional;
    private String mAttributeName;
    private String mDefaultValue;
    private boolean mIsNestedProcessor;
    private boolean mIsCollection;

    ParamTagInfo(String name, String kind, String text, String attributeName, boolean isOptional, String defaultValue, boolean isNestedProcessor, boolean isCollection, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
        Matcher m = PATTERN.matcher(text);
        if (m.matches()) {
            this.mParameterName = m.group(1);
            this.mParameterComment = m.group(2);
            int len = this.mParameterName.length();
            this.mIsTypeParameter = len > 2 && this.mParameterName.charAt(0) == '<' && this.mParameterName.charAt(len - 1) == '>';
        } else {
            this.mParameterName = text.trim();
            this.mParameterComment = "";
            this.mIsTypeParameter = false;
        }
        this.mIsOptional = isOptional;
        this.mAttributeName = attributeName;
        this.mDefaultValue = defaultValue;
        this.mIsNestedProcessor = isNestedProcessor;
        this.mIsCollection = isCollection;
        this.setCommentText(this.mParameterComment);
    }

    ParamTagInfo(String name, String kind, String text, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
        Matcher m = PATTERN.matcher(text);
        if (m.matches()) {
            this.mParameterName = m.group(1);
            this.mParameterComment = m.group(2);
            int len = this.mParameterName.length();
            this.mIsTypeParameter = len > 2 && this.mParameterName.charAt(0) == '<' && this.mParameterName.charAt(len - 1) == '>';
        } else {
            this.mParameterName = text.trim();
            this.mParameterComment = "";
            this.mIsTypeParameter = false;
        }
        this.setCommentText(this.mParameterComment);
    }

    ParamTagInfo(String name, String kind, String text, boolean isTypeParameter, String parameterComment, String parameterName, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
        this.mIsTypeParameter = isTypeParameter;
        this.mParameterComment = parameterComment;
        this.mParameterName = parameterName;
    }

    public boolean isTypeParameter() {
        return this.mIsTypeParameter;
    }

    public String parameterComment() {
        return this.mParameterComment;
    }

    public String parameterName() {
        return this.mParameterName;
    }

    public String attributeName() {
        return this.mAttributeName;
    }

    public String defaultValue() {
        return this.mDefaultValue;
    }

    public boolean optional() {
        return this.mIsOptional;
    }

    public boolean isNestedProcessor() {
        return this.mIsNestedProcessor;
    }

    public boolean isCollection() {
        return this.mIsCollection;
    }

    public void makeHDF(Data data, String base) {
        data.setValue(base + ".name", this.parameterName());
        data.setValue(base + ".attributeName", this.attributeName());
        data.setValue(base + ".optional", Boolean.toString(this.optional()));
        data.setValue(base + ".defaultValue", this.defaultValue());
        data.setValue(base + ".isTypeParameter", this.isTypeParameter() ? "1" : "0");
        data.setValue(base + ".isNestedProcessor", this.isNestedProcessor() ? "1" : "0");
        data.setValue(base + ".isCollection", this.isCollection() ? "1" : "0");
        TagInfo.makeHDF(data, base + ".comment", this.commentTags());
    }

    public static void makeHDF(Data data, String base, ParamTagInfo[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            tags[i].makeHDF(data, base + "." + i);
        }
    }
}

