/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import java.util.Comparator;
import org.mule.devkit.doclet.AnnotationInstanceInfo;
import org.mule.devkit.doclet.ClassInfo;
import org.mule.devkit.doclet.Doclava;
import org.mule.devkit.doclet.Errors;
import org.mule.devkit.doclet.MemberInfo;
import org.mule.devkit.doclet.SinceTagger;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;
import org.mule.devkit.doclet.TypeInfo;

public class FieldInfo
extends MemberInfo {
    public static final Comparator<FieldInfo> comparator = new Comparator<FieldInfo>(){

        @Override
        public int compare(FieldInfo a, FieldInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    boolean mIsTransient;
    boolean mIsVolatile;
    boolean mDeprecatedKnown;
    boolean mIsDeprecated;
    boolean mIsConfigurable;
    boolean mIsOptional;
    String mDefaultValue;
    boolean mConfigurableKnown;
    TypeInfo mType;
    Object mConstantValue;

    public FieldInfo(String name, ClassInfo containingClass, ClassInfo realContainingClass, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isFinal, boolean isStatic, boolean isTransient, boolean isVolatile, boolean isSynthetic, TypeInfo type, String rawCommentText, Object constantValue, SourcePositionInfo position, AnnotationInstanceInfo[] annotations) {
        super(rawCommentText, name, null, containingClass, realContainingClass, isPublic, isProtected, isPackagePrivate, isPrivate, isFinal, isStatic, isSynthetic, FieldInfo.chooseKind(isFinal, isStatic, constantValue), position, annotations);
        this.mIsTransient = isTransient;
        this.mIsVolatile = isVolatile;
        this.mType = type;
        this.mConstantValue = constantValue;
    }

    public FieldInfo cloneForClass(ClassInfo newContainingClass) {
        return new FieldInfo(this.name(), newContainingClass, this.realContainingClass(), this.isPublic(), this.isProtected(), this.isPackagePrivate(), this.isPrivate(), this.isFinal(), this.isStatic(), this.isTransient(), this.isVolatile(), this.isSynthetic(), this.mType, this.getRawCommentText(), this.mConstantValue, this.position(), this.annotations());
    }

    static String chooseKind(boolean isFinal, boolean isStatic, Object constantValue) {
        return FieldInfo.isConstant(isFinal, isStatic, constantValue) ? "constant" : "field";
    }

    public String qualifiedName() {
        String parentQName = this.containingClass() != null ? this.containingClass().qualifiedName() + "." : "";
        return parentQName + this.name();
    }

    public TypeInfo type() {
        return this.mType;
    }

    static boolean isConstant(boolean isFinal, boolean isStatic, Object constantValue) {
        return isFinal && isStatic && constantValue != null;
    }

    public boolean isConstant() {
        return FieldInfo.isConstant(this.isFinal(), this.isStatic(), this.mConstantValue);
    }

    public TagInfo[] firstSentenceTags() {
        return this.comment().briefTags();
    }

    public TagInfo[] inlineTags() {
        return this.comment().tags();
    }

    public Object constantValue() {
        return this.mConstantValue;
    }

    public String constantLiteralValue() {
        return FieldInfo.constantLiteralValue(this.mConstantValue);
    }

    public void setDeprecated(boolean deprecated) {
        this.mDeprecatedKnown = true;
        this.mIsDeprecated = deprecated;
    }

    public boolean isDeprecated() {
        if (!this.mDeprecatedKnown) {
            boolean commentDeprecated = this.comment().isDeprecated();
            boolean annotationDeprecated = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("java.lang.Deprecated")) continue;
                annotationDeprecated = true;
                break;
            }
            if (commentDeprecated != annotationDeprecated) {
                Errors.error(Errors.DEPRECATION_MISMATCH, this.position(), "Field " + this.mContainingClass.qualifiedName() + "." + this.name() + ": @Deprecated annotation and @deprecated comment do not match");
            }
            this.mIsDeprecated = commentDeprecated | annotationDeprecated;
            this.mDeprecatedKnown = true;
        }
        return this.mIsDeprecated;
    }

    public static String constantLiteralValue(Object val) {
        String str = null;
        if (val != null) {
            str = val instanceof Boolean || val instanceof Byte || val instanceof Short || val instanceof Integer ? val.toString() : (val instanceof Double ? FieldInfo.canonicalizeFloatingPoint(val.toString(), "") : (val instanceof Float ? FieldInfo.canonicalizeFloatingPoint(val.toString(), "f") : (val instanceof Long ? val.toString() + "L" : (val instanceof Character ? String.format("'\\u%04x'", val) : (val instanceof String ? "\"" + FieldInfo.javaEscapeString((String)val) + "\"" : "<<<<" + val.toString() + ">>>>")))));
        }
        if (str == null) {
            str = "null";
        }
        return str;
    }

    private static String canonicalizeFloatingPoint(String val, String suffix) {
        if (val.equals("Infinity")) {
            return "(1.0" + suffix + " / 0.0" + suffix + ")";
        }
        if (val.equals("-Infinity")) {
            return "(-1.0" + suffix + " / 0.0" + suffix + ")";
        }
        if (val.equals("NaN")) {
            return "(0.0" + suffix + " / 0.0" + suffix + ")";
        }
        String str = val.toString();
        if (str.indexOf(69) != -1) {
            return str + suffix;
        }
        int i = str.length() - 1;
        int d = str.indexOf(46);
        while (i >= d + 2 && str.charAt(i) == '0') {
            str = str.substring(0, i--);
        }
        return str + suffix;
    }

    public static String javaEscapeString(String str) {
        String result = "";
        int N = str.length();
        for (int i = 0; i < N; ++i) {
            char c = str.charAt(i);
            result = c == '\\' ? result + "\\\\" : (c == '\t' ? result + "\\t" : (c == '\b' ? result + "\\b" : (c == '\r' ? result + "\\r" : (c == '\n' ? result + "\\n" : (c == '\f' ? result + "\\f" : (c == '\'' ? result + "\\'" : (c == '\"' ? result + "\\\"" : (c >= ' ' && c <= '~' ? result + c : result + String.format("\\u%04x", new Integer(c))))))))));
        }
        return result;
    }

    public boolean isOptional() {
        return this.mIsOptional;
    }

    public String defaultValue() {
        return this.mDefaultValue;
    }

    public void makeHDF(Data data, String base) {
        data.setValue(base + ".kind", this.kind());
        this.type().makeHDF(data, base + ".type");
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".optional", Boolean.toString(this.isOptional()));
        data.setValue(base + ".defaultValue", this.defaultValue());
        data.setValue(base + ".href", this.htmlPage());
        data.setValue(base + ".anchor", this.anchor());
        TagInfo.makeHDF(data, base + ".shortDescr", this.firstSentenceTags());
        TagInfo.makeHDF(data, base + ".descr", this.inlineTags());
        TagInfo.makeHDF(data, base + ".deprecated", this.comment().deprecatedTags());
        TagInfo.makeHDF(data, base + ".seeAlso", this.comment().seeTags());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
        data.setValue(base + ".final", this.isFinal() ? "final" : "");
        data.setValue(base + ".static", this.isStatic() ? "static" : "");
        if (this.isPublic()) {
            data.setValue(base + ".scope", "public");
        } else if (this.isProtected()) {
            data.setValue(base + ".scope", "protected");
        } else if (this.isPackagePrivate()) {
            data.setValue(base + ".scope", "");
        } else if (this.isPrivate()) {
            data.setValue(base + ".scope", "private");
        }
        Object val = this.mConstantValue;
        if (val != null) {
            String dec = null;
            String hex = null;
            String str = null;
            if (val instanceof Boolean) {
                str = ((Boolean)val).toString();
            } else if (val instanceof Byte) {
                dec = String.format("%d", val);
                hex = String.format("0x%02x", val);
            } else if (val instanceof Character) {
                dec = String.format("'%c'", val);
                hex = String.format("0x%04x", val);
            } else if (val instanceof Double) {
                str = ((Double)val).toString();
            } else if (val instanceof Float) {
                str = ((Float)val).toString();
            } else if (val instanceof Integer) {
                dec = String.format("%d", val);
                hex = String.format("0x%08x", val);
            } else if (val instanceof Long) {
                dec = String.format("%d", val);
                hex = String.format("0x%016x", val);
            } else if (val instanceof Short) {
                dec = String.format("%d", val);
                hex = String.format("0x%04x", val);
            } else {
                str = val instanceof String ? "\"" + (String)val + "\"" : "";
            }
            if (dec != null && hex != null) {
                data.setValue(base + ".constantValue.dec", Doclava.escape(dec));
                data.setValue(base + ".constantValue.hex", Doclava.escape(hex));
            } else {
                data.setValue(base + ".constantValue.str", Doclava.escape(str));
                data.setValue(base + ".constantValue.isString", "1");
            }
        }
        this.setFederatedReferences(data, base);
    }

    @Override
    public boolean isExecutable() {
        return false;
    }

    public boolean isTransient() {
        return this.mIsTransient;
    }

    public boolean isVolatile() {
        return this.mIsVolatile;
    }

    private boolean valueEquals(FieldInfo other) {
        if (this.mConstantValue == null != (other.mConstantValue == null)) {
            return false;
        }
        if (this.mConstantValue == null) {
            return true;
        }
        if (!(this.mConstantValue instanceof String) || !(other.mConstantValue instanceof String)) {
            throw new AssertionError((Object)"Bad type for field value");
        }
        return this.mType.equals(other.mType) && this.mConstantValue.equals(other.mConstantValue);
    }

    public boolean isConsistent(FieldInfo fInfo) {
        boolean consistent = true;
        if (!this.mType.equals(fInfo.mType)) {
            Errors.error(Errors.CHANGED_TYPE, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed type");
            consistent = false;
        } else if (!this.valueEquals(fInfo)) {
            Errors.error(Errors.CHANGED_VALUE, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed value from " + this.mConstantValue + " to " + fInfo.mConstantValue);
            consistent = false;
        }
        if (!this.scope().equals(fInfo.scope())) {
            Errors.error(Errors.CHANGED_SCOPE, fInfo.position(), "Method " + fInfo.qualifiedName() + " changed scope from " + this.scope() + " to " + fInfo.scope());
            consistent = false;
        }
        if (this.mIsStatic != fInfo.mIsStatic) {
            Errors.error(Errors.CHANGED_STATIC, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed 'static' qualifier");
            consistent = false;
        }
        if (this.mIsFinal != fInfo.mIsFinal) {
            Errors.error(Errors.CHANGED_FINAL, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed 'final' qualifier");
            consistent = false;
        }
        if (this.mIsTransient != fInfo.mIsTransient) {
            Errors.error(Errors.CHANGED_TRANSIENT, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed 'transient' qualifier");
            consistent = false;
        }
        if (this.mIsVolatile != fInfo.mIsVolatile) {
            Errors.error(Errors.CHANGED_VOLATILE, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed 'volatile' qualifier");
            consistent = false;
        }
        if (this.isDeprecated() != fInfo.isDeprecated()) {
            Errors.error(Errors.CHANGED_DEPRECATED, fInfo.position(), "Field " + fInfo.qualifiedName() + " has changed deprecation state");
            consistent = false;
        }
        return consistent;
    }

    public boolean isConfigurable() {
        if (!this.mConfigurableKnown) {
            boolean annotationPresent = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("org.mule.api.annotations.Configurable")) continue;
                annotationPresent = true;
                this.mIsOptional = false;
                for (AnnotationInstanceInfo secondAnnotation : this.annotations()) {
                    if (!secondAnnotation.type().qualifiedName().equals("org.mule.api.annotations.param.Optional")) continue;
                    this.mIsOptional = true;
                }
                this.mDefaultValue = "";
                for (AnnotationInstanceInfo secondAnnotation : this.annotations()) {
                    if (!secondAnnotation.type().qualifiedName().equals("org.mule.api.annotations.param.Default")) continue;
                    this.mDefaultValue = secondAnnotation.elementValues()[0].valueString().replace("\"", "");
                }
                break;
            }
            this.mIsConfigurable = annotationPresent;
            this.mConfigurableKnown = true;
        }
        return this.mIsConfigurable;
    }
}

