/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import java.io.File;
import java.util.TreeSet;
import org.mule.devkit.doclet.ClearPage;
import org.mule.devkit.doclet.Doclava;
import org.mule.devkit.doclet.SampleTagInfo;
import org.mule.devkit.doclet.SourcePositionInfo;

public class SampleCode {
    String mSource;
    String mDest;
    String mTitle;
    public static String[] IMAGES = new String[]{".png", ".jpg", ".gif"};
    public static String[] TEMPLATED = new String[]{".java", ".xml", ".aidl", ".rs"};

    public SampleCode(String source, String dest, String title) {
        this.mSource = source;
        this.mTitle = title;
        int len = dest.length();
        this.mDest = len > 1 && dest.charAt(len - 1) != '/' ? dest + '/' : dest;
    }

    public void write(boolean offlineMode) {
        File f = new File(this.mSource);
        if (!f.isDirectory()) {
            System.out.println("-samplecode not a directory: " + this.mSource);
            return;
        }
        this.writeDirectory(f, this.mDest, offlineMode);
    }

    public static String convertExtension(String s, String ext) {
        return s.substring(0, s.lastIndexOf(46)) + ext;
    }

    public static boolean inList(String s, String[] list) {
        for (String t : list) {
            if (!s.endsWith(t)) continue;
            return true;
        }
        return false;
    }

    public void writeDirectory(File dir, String relative) {
        this.writeDirectory(dir, relative, false);
    }

    public void writeDirectory(File dir, String relative, boolean offline) {
        TreeSet<String> dirs = new TreeSet<String>();
        TreeSet<String> files = new TreeSet<String>();
        String subdir = relative;
        for (File file : dir.listFiles()) {
            String name = file.getName();
            if (name.startsWith(".") || name.startsWith("_")) continue;
            if (file.isFile()) {
                String out = relative + name;
                if (SampleCode.inList(out, IMAGES)) {
                    ClearPage.copyFile(file, new File(ClearPage.outputDir + "/" + out));
                    this.writeImagePage(file, SampleCode.convertExtension(out, Doclava.htmlExtension), subdir);
                    files.add(name);
                }
                if (!SampleCode.inList(out, TEMPLATED)) continue;
                ClearPage.copyFile(file, new File(ClearPage.outputDir + "/" + out));
                this.writePage(file, SampleCode.convertExtension(out, Doclava.htmlExtension), subdir);
                files.add(name);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.writeDirectory(file, relative + name + "/", offline);
            dirs.add(name);
        }
        Data hdf = this.writeIndex(dir);
        hdf.setValue("subdir", subdir);
        int i = 0;
        for (String string : dirs) {
            hdf.setValue("subdirs." + i + ".name", string);
            ++i;
        }
        i = 0;
        for (String string : files) {
            hdf.setValue("files." + i + ".name", string);
            hdf.setValue("files." + i + ".href", SampleCode.convertExtension(string, ".html"));
            ++i;
        }
        if (!offline) {
            relative = "/" + relative;
        }
        ClearPage.write(hdf, "sampleindex.cs", relative + "index" + Doclava.htmlExtension);
    }

    public Data writeIndex(File dir) {
        Data hdf = Doclava.makeHDF();
        hdf.setValue("page.title", dir.getName() + " - " + this.mTitle);
        hdf.setValue("projectTitle", this.mTitle);
        String filename = dir.getPath() + "/_index.html";
        String summary = SampleTagInfo.readFile(new SourcePositionInfo(filename, -1, -1), filename, "sample code", true, false, true);
        if (summary == null) {
            summary = "";
        }
        hdf.setValue("summary", summary);
        return hdf;
    }

    public void writePage(File f, String out, String subdir) {
        String name = f.getName();
        String filename = f.getPath();
        String data = SampleTagInfo.readFile(new SourcePositionInfo(filename, -1, -1), filename, "sample code", true, true, true);
        data = Doclava.escape(data);
        Data hdf = Doclava.makeHDF();
        hdf.setValue("page.title", name);
        hdf.setValue("subdir", subdir);
        hdf.setValue("realFile", name);
        hdf.setValue("fileContents", data);
        ClearPage.write(hdf, "sample.cs", out);
    }

    public void writeImagePage(File f, String out, String subdir) {
        String name = f.getName();
        String data = "<img src=\"" + name + "\" title=\"" + name + "\" />";
        Data hdf = Doclava.makeHDF();
        hdf.setValue("page.title", name);
        hdf.setValue("subdir", subdir);
        hdf.setValue("realFile", name);
        hdf.setValue("fileContents", data);
        ClearPage.write(hdf, "sample.cs", out);
    }
}

