<?cs set:section = "mule" ?>
<?cs include:"doctype.cs" ?>
<?cs include:"macros.cs" ?>
<html>
<?cs include:"head_tag.cs" ?>
<body class="<?cs var:class.since.key ?>">
<?cs call:custom_masthead() ?>

<div class="g-unit" id="all-content">

<div id="api-info-block">

<div class="sum-details-links">
<?cs if:doclava.generate.sources ?>
<div>
<a href="<?cs var:class.moduleName ?>-schema.html">View Schema</a>
</div>
<?cs /if ?>
Summary:
<a href="#lconfig">Configuration</a>
<?cs if:subcount(class.methods.processor) ?>
  &#124; <a href="#promethods">Message Processors</a>
<?cs /if ?>
<?cs if:subcount(class.methods.source) ?>
  &#124; <a href="#soumethods">Message Sources</a>
<?cs /if ?>
<?cs if:subcount(class.methods.transformer) ?>
  &#124; <a href="#trnasmethods">Transformers</a>
<?cs /if ?>
</div><!-- end sum-details-links -->

<div class="api-level">
  <?cs call:since_tags(class) ?>
  <?cs call:federated_refs(class) ?>
</div>
</div><!-- end api-info-block -->

<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ======== START OF MODULE DATA ======== -->

<div id="jd-header">
    <?cs var:project.groupId ?>
<h1><?cs var:project.artifactId ?></h1>
    <?cs var:class.moduleConfigElementName ?>

</div><!-- end header -->

<div id="naMessage"></div>

<div id="jd-content" class="api apilevel-<?cs var:class.since.key ?>">
<?cs # this next line must be exactly like this to be parsed by eclipse ?>

<br/>

<div class="jd-tagdata">
      <table class="jd-tagtable">
        <tbody><tr>
          <th>Namespace</th><td><?cs var:class.moduleNamespace ?></td>
        </tr><tr>
          <th>Schema Location</th><td><?cs var:class.moduleSchemaLocation ?>&nbsp;&nbsp;(<a href="<?cs var:class.moduleSchemaPath ?>">View Schema</a>)</td>
        </tr>
<tr>
          <th>Schema Version</th><td><?cs var:class.moduleVersion ?></td>
        </tr>
<tr>
          <th>Minimum Mule Version</th><td><?cs var:class.moduleMinMuleVersion ?></td>
        </tr>
    </tbody></table>
  </div>

<div class="jd-descr">
<?cs call:deprecated_warning(class) ?>
<?cs if:subcount(class.descr) ?>
<h2>Module Overview</h2>
<p><?cs call:op_tag_list(class.descr) ?></p>
<?cs /if ?>

</div><!-- jd-descr -->


<?cs # summary macros ?>

<?cs def:write_op_summary(methods, included) ?>
<?cs set:count = #1 ?>
<?cs each:method = methods ?>
	 <?cs # The apilevel-N class MUST BE LAST in the sequence of class names ?>
    <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:method.since.key ?>" >
        <td class="jd-linkcol" width="100%"><nobr>
        <span class="sympad"><?cs call:cond_link("&lt;" + class.moduleName + ":" + method.elementName + "&gt;", toroot + "mule/", method.modhref, included) ?></nobr>
        <?cs if:subcount(method.shortDescr) || subcount(method.deprecated) ?>
        <div class="jd-descrdiv"><?cs call:op_short_descr(method) ?></div>
        <?cs /if ?>
  </td></tr>
<?cs set:count = count + #1 ?>
<?cs /each ?>
<?cs /def ?>

<?cs def:write_config_summary(fields) ?>
<?cs /def ?>


<?cs # end macros ?>

<div class="jd-descr">
<?cs # make sure there's a summary view to display ?>
<?cs if:subcount(class.config)
     || subcount(class.methods.processor)
     || subcount(class.methods.source)
     || subcount(class.methods.transformer)
     || subcount(class.methods.category) ?>
<h2>Summary</h2>

<!-- Config -->
<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- =========== CONFIG SUMMARY =========== -->
<table id="lconfig" class="jd-sumtable"><tr><th colspan="12">Configuration</th></tr>
	 <?cs # The apilevel-N class MUST BE LAST in the sequence of class names ?>
    <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:method.since.key ?>" >
        <td class="jd-linkcol" width="100%"><nobr>
        <span class="sympad"><?cs call:link("&lt;" + class.moduleName + ":" + class.moduleConfigElementName + "&gt;", toroot + "mule/", class.moduleName + "-" + class.moduleConfigElementName + ".html#" + class.moduleConfigElementName) ?></nobr>
        <div class="jd-descrdiv">Configure an instance of this module</div>
  </td></tr>
</table>

<?cs if:subcount(class.methods.category) ?>
<?cs each:category=class.methods.category ?>
<table id="promethods" class="jd-sumtable">
<tr><th colspan="12"><?cs var:category.name ?><br/><span style="font-weight: 200;"><?cs var:category.description ?></span></th></tr>
    <?cs if:subcount(category.processor) ?>
    <?cs # this next line must be exactly like this to be parsed by eclipse ?>
    <!-- ========== MESSAGE PROCESSOR SUMMARY =========== -->
    <?cs call:write_op_summary(category.processor, 1) ?>
    <?cs /if ?>
    <?cs if:subcount(category.source) ?>
    <?cs # this next line must be exactly like this to be parsed by eclipse ?>
    <!-- ========== MESSAGE SOURCE SUMMARY =========== -->
    <?cs call:write_op_summary(category.source, 1) ?>
    <?cs /if ?>
    <?cs if:subcount(category.transformer) ?>
    <?cs # this next line must be exactly like this to be parsed by eclipse ?>
    <!-- ========== MESSAGE TRANSFORMER SUMMARY =========== -->
    <?cs call:write_op_summary(category.transformer, 1) ?>
    <?cs /if ?>
</table>
<?cs /each ?>
<?cs /if ?>

<?cs if:subcount(class.methods.processor) ?>
<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========== MESSAGE PROCESSOR SUMMARY =========== -->
<table id="promethods" class="jd-sumtable"><tr><th colspan="12">Message Processors</th></tr>
<?cs call:write_op_summary(class.methods.processor, 1) ?>
</table>
<?cs /if ?>

<?cs if:subcount(class.methods.source) ?>
<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========== MESSAGE SOURCE SUMMARY =========== -->
<table id="soumethods" class="jd-sumtable"><tr><th colspan="12">Message Sources</th></tr>
<?cs call:write_op_summary(class.methods.source, 1) ?>
</table>
<?cs /if ?>

<?cs if:subcount(class.methods.transformer) ?>
<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========== TRANSFORMER SUMMARY =========== -->
<table id="trnasmethods" class="jd-sumtable"><tr><th colspan="12">Transformers</th></tr>
<?cs call:write_op_summary(class.methods.transformer, 1) ?>
</table>
<?cs /if ?>

<?cs /if ?>

</div><!-- jd-descr (summary) -->

<?cs include:"config_detail.cs" ?>

<?cs if:class.moduleSessionAware=="true" ?>
<?cs include:"connection_manager.cs" ?>
<?cs /if ?>

<?cs if:(class.moduleOAuth1Aware=="true" || class.moduleOAuth2Aware=="true") && class.moduleOAuthManagement=="false"?>
<?cs include:"oauth_std.cs" ?>
<?cs /if ?>

<?cs if:(class.moduleOAuth1Aware=="true" || class.moduleOAuth2Aware=="true") && class.moduleOAuthManagement=="true"?>
<?cs include:"oauth_manager.cs" ?>
<?cs /if ?>

<?cs def:write_op_details(methods) ?>
<?cs each:method=methods ?>
<?cs # the A tag in the next line must remain where it is, so that Eclipse can parse the docs ?>
<A NAME="<?cs var:method.elementName ?>"></A>
<?cs # The apilevel-N class MUST BE LAST in the sequence of class names ?>
<div class="jd-details api apilevel-<?cs var:method.since.key ?>">
    <h4 class="jd-details-title">
      <span class="sympad">&lt;<?cs var:class.moduleName ?>:<?cs var:method.elementName ?>&gt;</span>
    </h4>
      <div class="api-level">
        <div><?cs call:since_tags(method) ?></div>
      </div>
    <div class="jd-details-descr">
      <?cs call:op_description(method) ?>
    </div>
</div>
<?cs /each ?>
<?cs /def ?>

<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========= MESSAGE PROCESSOR DETAIL ======== -->
<!-- Message Processors -->
<h2>Message Processors</h2>
<?cs if:subcount(class.methods.category) ?>
<?cs each:category=class.methods.category ?>
    <?cs if:subcount(category.processor) ?>
    <?cs call:write_op_details(category.processor) ?>
    <?cs /if ?>
<?cs /each ?>
<?cs if:subcount(class.methods.processor) ?>
<?cs call:write_op_details(class.methods.processor) ?>
<?cs /if ?>
<?cs /if ?>

<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========= MESSAGE SOURCES DETAIL ======== -->
<!-- Message Sources -->
<h2>Message Sources</h2>
<?cs if:subcount(class.methods.category) ?>
<?cs each:category=class.methods.category ?>
    <?cs if:subcount(category.source) ?>
    <?cs call:write_op_details(category.source) ?>
    <?cs /if ?>
<?cs /each ?>
<?cs if:subcount(class.methods.source) ?>
<?cs call:write_op_details(class.methods.source) ?>
<?cs /if ?>
<?cs /if ?>

<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========= MESSAGE SOURCES DETAIL ======== -->
<!-- Transformers -->
<h2>Transformers</h2>
<?cs if:subcount(class.methods.category) ?>
<?cs each:category=class.methods.category ?>
    <?cs if:subcount(category.transformer) ?>
    <?cs call:write_op_details(category.transformer) ?>
    <?cs /if ?>
<?cs /each ?>
<?cs if:subcount(class.methods.transformer) ?>
<?cs call:write_op_details(class.methods.transformer) ?>
<?cs /if ?>
<?cs /if ?>

<?cs # the next two lines must be exactly like this to be parsed by eclipse ?>
<!-- ========= END OF CLASS DATA ========= -->
<A NAME="navbar_top"></A>

<?cs include:"footer.cs" ?>
</div> <!-- jd-content -->

</div><!-- end doc-content -->

<?cs include:"trailer.cs" ?>

</body>
</html>
