/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.resourceloader.ClassResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.CompositeResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.FileSystemResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.javadoc.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.devkit.doclet.ClassInfo;
import org.mule.devkit.doclet.ClearPage;
import org.mule.devkit.doclet.Converter;
import org.mule.devkit.doclet.DocFile;
import org.mule.devkit.doclet.DocInfo;
import org.mule.devkit.doclet.Errors;
import org.mule.devkit.doclet.FederationTagger;
import org.mule.devkit.doclet.Hierarchy;
import org.mule.devkit.doclet.JarUtils;
import org.mule.devkit.doclet.MethodInfo;
import org.mule.devkit.doclet.NavTree;
import org.mule.devkit.doclet.PackageInfo;
import org.mule.devkit.doclet.Proofread;
import org.mule.devkit.doclet.SampleTagInfo;
import org.mule.devkit.doclet.SinceTagger;
import org.mule.devkit.doclet.Sorter;
import org.mule.devkit.doclet.Stubs;
import org.mule.devkit.doclet.TagInfo;
import org.mule.devkit.doclet.TocInfo;
import org.mule.devkit.doclet.TodoFile;
import org.mule.devkit.doclet.markdown.MarkdownProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doclava {
    public static final int SHOW_PUBLIC = 1;
    public static final int SHOW_PROTECTED = 3;
    public static final int SHOW_PACKAGE = 7;
    public static final int SHOW_PRIVATE = 15;
    public static final int SHOW_HIDDEN = 31;
    public static int showLevel = 3;
    public static final String javadocDir = "java/";
    public static final String muleXmlDir = "mule/";
    public static final String guideDir = "guide/";
    public static String assetsOutputDir = "assets";
    public static String htmlExtension;
    public static RootDoc root;
    public static ArrayList<String[]> mHDFData;
    public static ArrayList<String[]> mMarkdown;
    public static Map<Character, String> escapeChars;
    public static String title;
    public static SinceTagger sinceTagger;
    public static HashSet<String> knownTags;
    public static FederationTagger federationTagger;
    private static boolean generateDocs;
    private static boolean generateSources;
    private static boolean parseComments;
    public static String apiVersion;
    public static JSilver jSilver;
    private static PackageInfo[] sVisiblePackages;

    public static boolean checkLevel(int level) {
        return (showLevel & level) == level;
    }

    public static boolean parseComments() {
        return generateDocs || parseComments;
    }

    public static boolean checkLevel(boolean pub, boolean prot, boolean pkgp, boolean priv, boolean hidden) {
        if (hidden && !Doclava.checkLevel(31)) {
            return false;
        }
        if (pub && Doclava.checkLevel(1)) {
            return true;
        }
        if (prot && Doclava.checkLevel(3)) {
            return true;
        }
        if (pkgp && Doclava.checkLevel(7)) {
            return true;
        }
        return priv && Doclava.checkLevel(15);
    }

    public static void main(String[] args) {
        Main.execute((String[])args);
    }

    public static boolean start(RootDoc r) {
        String[][] options;
        String keepListFile = null;
        String proofreadFile = null;
        String todoFile = null;
        String stubsDir = null;
        String apiFile = null;
        HashSet<String> stubPackages = null;
        ArrayList<String> knownTagsFiles = new ArrayList<String>();
        root = r;
        for (String[] a : options = r.options()) {
            if (a[0].equals("-d")) {
                ClearPage.outputDir = a[1];
                continue;
            }
            if (a[0].equals("-templatedir")) {
                ClearPage.addTemplateDir(a[1]);
                continue;
            }
            if (a[0].equals("-hdf")) {
                mHDFData.add(new String[]{a[1], a[2]});
                continue;
            }
            if (a[0].equals("-markdown")) {
                mMarkdown.add(new String[]{a[1], a[2], a[3]});
                continue;
            }
            if (a[0].equals("-knowntags")) {
                knownTagsFiles.add(a[1]);
                continue;
            }
            if (a[0].equals("-toroot")) {
                ClearPage.toroot = a[1];
                continue;
            }
            if (a[0].equals("-title")) {
                title = a[1];
                continue;
            }
            if (a[0].equals("-werror")) {
                Errors.setWarningsAreErrors(true);
                continue;
            }
            if (a[0].equals("-error") || a[0].equals("-warning") || a[0].equals("-hide")) {
                try {
                    int level = -1;
                    if (a[0].equals("-error")) {
                        level = Errors.ERROR;
                    } else if (a[0].equals("-warning")) {
                        level = Errors.WARNING;
                    } else if (a[0].equals("-hide")) {
                        level = Errors.HIDDEN;
                    }
                    Errors.setErrorLevel(Integer.parseInt(a[1]), level);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (a[0].equals("-keeplist")) {
                keepListFile = a[1];
                continue;
            }
            if (a[0].equals("-proofread")) {
                proofreadFile = a[1];
                continue;
            }
            if (a[0].equals("-todo")) {
                todoFile = a[1];
                continue;
            }
            if (a[0].equals("-public")) {
                showLevel = 1;
                continue;
            }
            if (a[0].equals("-protected")) {
                showLevel = 3;
                continue;
            }
            if (a[0].equals("-package")) {
                showLevel = 7;
                continue;
            }
            if (a[0].equals("-private")) {
                showLevel = 15;
                continue;
            }
            if (a[0].equals("-hidden")) {
                showLevel = 31;
                continue;
            }
            if (a[0].equals("-stubs")) {
                stubsDir = a[1];
                continue;
            }
            if (a[0].equals("-stubpackages")) {
                stubPackages = new HashSet<String>();
                for (String pkg : a[1].split(":")) {
                    stubPackages.add(pkg);
                }
                continue;
            }
            if (a[0].equals("-apixml")) {
                apiFile = a[1];
                continue;
            }
            if (a[0].equals("-nodocs")) {
                generateDocs = false;
                continue;
            }
            if (a[0].equals("-parsecomments")) {
                parseComments = true;
                continue;
            }
            if (a[0].equals("-since")) {
                sinceTagger.addVersion(a[1], a[2]);
                continue;
            }
            if (a[0].equals("-federate")) {
                try {
                    String name = a[1];
                    URL federationURL = new URL(a[2]);
                    federationTagger.addSiteUrl(name, federationURL);
                    continue;
                }
                catch (MalformedURLException e) {
                    System.err.println("Could not parse URL for federation: " + a[1]);
                    return false;
                }
            }
            if (a[0].equals("-federationxml")) {
                String name = a[1];
                String file = a[2];
                federationTagger.addSiteXml(name, file);
                continue;
            }
            if (a[0].equals("-apiversion")) {
                apiVersion = a[1];
                continue;
            }
            if (a[0].equals("-assetsdir")) {
                assetsOutputDir = a[1];
                continue;
            }
            if (!a[0].equals("-generatesources")) continue;
            generateSources = true;
        }
        if (!Doclava.readKnownTagsFiles(knownTags, knownTagsFiles)) {
            return false;
        }
        Converter.makeInfo(r);
        File currentApiFile = !generateDocs && apiFile != null ? new File(apiFile) : (generateDocs ? new File(Doclava.ensureSlash(ClearPage.outputDir) + javadocDir + "/current.xml") : null);
        Stubs.writeStubsAndXml(stubsDir, currentApiFile, stubPackages);
        if (generateDocs && apiFile != null) {
            ClearPage.copyFile(currentApiFile, new File(apiFile));
        }
        if (generateDocs) {
            ClearPage.addBundledTemplateDir("assets/customizations");
            ClearPage.addBundledTemplateDir("assets/templates");
            ArrayList<Object> resourceLoaders = new ArrayList<Object>();
            List<String> templates = ClearPage.getTemplateDirs();
            for (String tmpl : templates) {
                resourceLoaders.add(new FileSystemResourceLoader(tmpl));
            }
            templates = ClearPage.getBundledTemplateDirs();
            for (String tmpl : templates) {
                resourceLoaders.add(new ClassResourceLoader(Doclava.class, '/' + tmpl));
            }
            CompositeResourceLoader compositeResourceLoader = new CompositeResourceLoader(resourceLoaders);
            jSilver = new JSilver((ResourceLoader)compositeResourceLoader);
            if (!Doclava.readTemplateSettings()) {
                return false;
            }
            long startTime = System.nanoTime();
            if (apiVersion != null && sinceTagger.hasVersions()) {
                sinceTagger.addVersion(currentApiFile.getAbsolutePath(), apiVersion);
            }
            sinceTagger.tagAll(Converter.rootClasses());
            federationTagger.tagAll(Converter.rootClasses());
            if (proofreadFile != null) {
                Proofread.initProofread(proofreadFile);
            }
            if (todoFile != null) {
                TodoFile.writeTodoFile(todoFile);
            }
            Doclava.writeAssets();
            NavTree.writeNavTree(assetsOutputDir);
            Doclava.writeMarkdowns();
            Doclava.writeModules("mule/modules" + htmlExtension);
            Doclava.writePackages("java/packages" + htmlExtension);
            Doclava.writeClassLists();
            Doclava.writeClasses();
            Doclava.writeHierarchy();
            Doclava.writeLists();
            if (keepListFile != null) {
                Doclava.writeKeepList(keepListFile);
            }
            Doclava.writeIndex();
            Doclava.writeInstall();
            Proofread.finishProofread(proofreadFile);
            long time = System.nanoTime() - startTime;
            System.out.println("Mule DevKit took " + time / 1000000000L + " sec. to write docs to " + ClearPage.outputDir);
        }
        Errors.printErrors();
        return !Errors.hadError;
    }

    private static void writeIndex() {
        Data data = Doclava.makeHDF();
        ClearPage.write(data, "index.cs", "index" + htmlExtension);
    }

    private static void writeInstall() {
        Data data = Doclava.makeHDF();
        ClearPage.write(data, "install.cs", "guide/install" + htmlExtension);
    }

    private static boolean readTemplateSettings() {
        Data data = Doclava.makeHDF();
        htmlExtension = ".html";
        int i = 0;
        while (true) {
            String k = data.getValue("template.escape." + i + ".key", "");
            String v = data.getValue("template.escape." + i + ".value", "");
            if ("".equals(k)) break;
            if (k.length() != 1) {
                System.err.println("template.escape." + i + ".key must have a length of 1: " + k);
                return false;
            }
            escapeChars.put(Character.valueOf(k.charAt(0)), v);
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readKnownTagsFiles(HashSet<String> knownTags, ArrayList<String> knownTagsFiles) {
        for (String fn : knownTagsFiles) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(fn));
                int lineno = 0;
                boolean fail = false;
                while (true) {
                    ++lineno;
                    String line = in.readLine();
                    if (line == null) break;
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    String[] words = line.split("\\s+", 2);
                    if (words.length == 2 && words[1].charAt(0) != '#') {
                        System.err.println(fn + ":" + lineno + ": Only one tag allowed per line: " + line);
                        fail = true;
                        continue;
                    }
                    knownTags.add(words[0]);
                }
                if (!fail) continue;
                boolean line = false;
                return line;
            }
            catch (IOException ex) {
                System.err.println("Error reading file: " + fn + " (" + ex.getMessage() + ")");
                boolean bl = false;
                return bl;
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return true;
    }

    public static String escape(String s) {
        if (escapeChars.size() == 0) {
            return s;
        }
        StringBuffer b = null;
        int begin = 0;
        int N = s.length();
        for (int i = 0; i < N; ++i) {
            char c = s.charAt(i);
            String mapped = escapeChars.get(Character.valueOf(c));
            if (mapped == null) continue;
            if (b == null) {
                b = new StringBuffer(s.length() + mapped.length());
            }
            if (begin != i) {
                b.append(s.substring(begin, i));
            }
            b.append(mapped);
            begin = i + 1;
        }
        if (b != null) {
            if (begin != N) {
                b.append(s.substring(begin, N));
            }
            return b.toString();
        }
        return s;
    }

    public static void setPageTitle(Data data, String title) {
        String s = title;
        if (Doclava.title.length() > 0) {
            s = s + " - " + Doclava.title;
        }
        data.setValue("page.title", s);
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        if (option.equals("-d")) {
            return 2;
        }
        if (option.equals("-templatedir")) {
            return 2;
        }
        if (option.equals("-hdf")) {
            return 3;
        }
        if (option.equals("-markdown")) {
            return 4;
        }
        if (option.equals("-knowntags")) {
            return 2;
        }
        if (option.equals("-toroot")) {
            return 2;
        }
        if (option.equals("-samplecode")) {
            return 4;
        }
        if (option.equals("-title")) {
            return 2;
        }
        if (option.equals("-werror")) {
            return 1;
        }
        if (option.equals("-hide")) {
            return 2;
        }
        if (option.equals("-warning")) {
            return 2;
        }
        if (option.equals("-error")) {
            return 2;
        }
        if (option.equals("-keeplist")) {
            return 2;
        }
        if (option.equals("-proofread")) {
            return 2;
        }
        if (option.equals("-todo")) {
            return 2;
        }
        if (option.equals("-public")) {
            return 1;
        }
        if (option.equals("-protected")) {
            return 1;
        }
        if (option.equals("-package")) {
            return 1;
        }
        if (option.equals("-private")) {
            return 1;
        }
        if (option.equals("-hidden")) {
            return 1;
        }
        if (option.equals("-stubs")) {
            return 2;
        }
        if (option.equals("-stubpackages")) {
            return 2;
        }
        if (option.equals("-sdkvalues")) {
            return 2;
        }
        if (option.equals("-apixml")) {
            return 2;
        }
        if (option.equals("-nodocs")) {
            return 1;
        }
        if (option.equals("-parsecomments")) {
            return 1;
        }
        if (option.equals("-since")) {
            return 3;
        }
        if (option.equals("-offlinemode")) {
            return 1;
        }
        if (option.equals("-federate")) {
            return 3;
        }
        if (option.equals("-federationxml")) {
            return 3;
        }
        if (option.equals("-apiversion")) {
            return 2;
        }
        if (option.equals("-assetsdir")) {
            return 2;
        }
        if (option.equals("-generatesources")) {
            return 1;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter r) {
        for (String[] a : options) {
            if (!a[0].equals("-error") && !a[0].equals("-warning") && !a[0].equals("-hide")) continue;
            try {
                Integer.parseInt(a[1]);
            }
            catch (NumberFormatException e) {
                r.printError("bad -" + a[0] + " value must be a number: " + a[1]);
                return false;
            }
        }
        return true;
    }

    public static Data makeHDF() {
        ClassInfo[] classes;
        Data data = jSilver.createData();
        for (String[] p : mHDFData) {
            data.setValue(p[0], p[1]);
        }
        data.setValue("tabs.0.id", "guide");
        data.setValue("tabs.0.title", "Install Guide");
        data.setValue("tabs.0.link", "guide/install.html");
        int i = 0;
        for (String[] p : mMarkdown) {
            data.setValue("tabs." + ++i + ".id", p[0]);
            data.setValue("tabs." + i + ".title", p[2]);
            String outFile = FilenameUtils.getName((String)p[1]).replaceAll(".md", ".html").toLowerCase();
            data.setValue("tabs." + i + ".link", outFile);
        }
        data.setValue("tabs." + ++i + ".id", "java");
        data.setValue("tabs." + i + ".title", "Java API Reference");
        data.setValue("tabs." + i + ".link", "java/packages.html");
        boolean hasModules = false;
        for (ClassInfo cl : classes = Converter.rootClasses()) {
            if (!cl.isModule()) continue;
            hasModules = true;
        }
        if (hasModules) {
            data.setValue("tabs." + ++i + ".id", "mule");
            data.setValue("tabs." + i + ".title", "Mule API Reference");
            data.setValue("tabs." + i + ".link", "mule/modules.html");
        }
        return data;
    }

    public static Data makePackageHDF() {
        Data data = Doclava.makeHDF();
        ClassInfo[] classes = Converter.rootClasses();
        TreeMap<String, PackageInfo> sorted = new TreeMap<String, PackageInfo>();
        for (ClassInfo cl : classes) {
            PackageInfo pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        int i = 0;
        for (String s : sorted.keySet()) {
            PackageInfo pkg = (PackageInfo)sorted.get(s);
            if (pkg.isHidden()) continue;
            Boolean allHidden = true;
            ClassInfo[] classesToCheck = null;
            for (int pass = 0; pass < 5; ++pass) {
                switch (pass) {
                    case 0: {
                        classesToCheck = pkg.ordinaryClasses();
                        break;
                    }
                    case 1: {
                        classesToCheck = pkg.enums();
                        break;
                    }
                    case 2: {
                        classesToCheck = pkg.errors();
                        break;
                    }
                    case 3: {
                        classesToCheck = pkg.exceptions();
                        break;
                    }
                    case 4: {
                        classesToCheck = pkg.getInterfaces();
                        break;
                    }
                    default: {
                        System.err.println("Error reading package: " + pkg.name());
                    }
                }
                for (ClassInfo cl : classesToCheck) {
                    if (cl.isHidden()) continue;
                    allHidden = false;
                    break;
                }
                if (!allHidden.booleanValue()) break;
            }
            if (allHidden.booleanValue()) continue;
            data.setValue("reference", "1");
            data.setValue("reference.apilevels", sinceTagger.hasVersions() ? "1" : "0");
            data.setValue("docs.packages." + i + ".name", s);
            data.setValue("docs.packages." + i + ".link", pkg.htmlPage());
            data.setValue("docs.packages." + i + ".since.key", SinceTagger.keyForName(pkg.getSince()));
            data.setValue("docs.packages." + i + ".since.name", pkg.getSince());
            TagInfo.makeHDF(data, "docs.packages." + i + ".shortDescr", pkg.firstSentenceTags());
            ++i;
        }
        sinceTagger.writeVersionNames(data);
        return data;
    }

    private static void writeDirectory(Map<String, List<TocInfo>> toc, File dir, String relative, JSilver js, String out) {
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                String templ = Doclava.ensureSlash(relative) + f.getName();
                int len = templ.length();
                if (len > 3 && ".jd".equals(templ.substring(len - 3))) {
                    String filename = out + templ.substring(0, len - 3) + htmlExtension;
                    DocFile.writePage(toc, f.getAbsolutePath(), relative, filename);
                    continue;
                }
                ClearPage.copyFile(f, new File(Doclava.ensureSlash(out) + templ));
                continue;
            }
            if (!f.isDirectory()) continue;
            Doclava.writeDirectory(toc, f, Doclava.ensureSlash(relative) + f.getName() + "/", js, out);
        }
    }

    public static void writeAssets() {
        List<String> templateDirs;
        JarFile thisJar = JarUtils.jarForClass(Doclava.class, null);
        if (thisJar != null) {
            try {
                templateDirs = ClearPage.getBundledTemplateDirs();
                for (String templateDir : templateDirs) {
                    String assetsDir = Doclava.ensureSlash(templateDir) + "assets";
                    JarUtils.copyResourcesToDirectory(thisJar, assetsDir, Doclava.ensureSlash(ClearPage.outputDir) + assetsOutputDir);
                }
                Data data = Doclava.makeHDF();
                ClearPage.write(data, "mule-developer-core.cs", assetsOutputDir + "/mule-developer-core.css");
            }
            catch (IOException e) {
                System.err.println("Error copying assets directory.");
                e.printStackTrace();
                return;
            }
        }
        templateDirs = ClearPage.getTemplateDirs();
        for (String templateDir : templateDirs) {
            File assets = new File(Doclava.ensureSlash(templateDir) + "assets");
            if (!assets.isDirectory()) continue;
            Doclava.writeDirectory(null, assets, assetsOutputDir, null, "");
        }
    }

    public static void writeLists() {
        PackageInfo pkg;
        Data data = Doclava.makeHDF();
        ClassInfo[] classes = Converter.rootClasses();
        TreeMap<String, DocInfo> sorted = new TreeMap<String, DocInfo>();
        for (ClassInfo cl : classes) {
            if (cl.isHidden()) continue;
            sorted.put(cl.qualifiedName(), cl);
            pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
            for (MethodInfo method : cl.methods()) {
                if (!method.isProcessor() && !method.isSource() && !method.isTransformer()) continue;
                sorted.put(method.elementName(), method);
            }
        }
        int i = 0;
        for (String s : sorted.keySet()) {
            data.setValue("docs.pages." + i + ".id", "" + i);
            data.setValue("docs.pages." + i + ".label", s);
            Object o = sorted.get(s);
            if (o instanceof PackageInfo) {
                pkg = (PackageInfo)o;
                data.setValue("docs.pages." + i + ".link", javadocDir + pkg.htmlPage());
                data.setValue("docs.pages." + i + ".type", "package");
            } else if (o instanceof ClassInfo) {
                ClassInfo cl = (ClassInfo)o;
                data.setValue("docs.pages." + i + ".link", javadocDir + cl.htmlPage());
                data.setValue("docs.pages." + i + ".type", "class");
            } else if (o instanceof MethodInfo) {
                MethodInfo mi = (MethodInfo)o;
                data.setValue("docs.pages." + i + ".id", "" + i);
                data.setValue("docs.pages." + i + ".link", muleXmlDir + mi.relativeModulePath());
                data.setValue("docs.pages." + i + ".type", "method");
            }
            ++i;
        }
        ClearPage.write(data, "lists.cs", "java/lists.js");
    }

    public static void cantStripThis(ClassInfo cl, HashSet<ClassInfo> notStrippable) {
        if (!notStrippable.add(cl)) {
            return;
        }
        ClassInfo supr = cl.superclass();
        if (supr != null) {
            Doclava.cantStripThis(supr, notStrippable);
        }
        for (ClassInfo iface : cl.getInterfaces()) {
            Doclava.cantStripThis(iface, notStrippable);
        }
    }

    private static String getPrintableName(ClassInfo cl) {
        ClassInfo containingClass = cl.containingClass();
        if (containingClass != null) {
            String baseName = cl.name();
            baseName = baseName.substring(baseName.lastIndexOf(46) + 1);
            return Doclava.getPrintableName(containingClass) + '$' + baseName;
        }
        return cl.qualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeKeepList(String filename) {
        HashSet<ClassInfo> notStrippable = new HashSet<ClassInfo>();
        Object[] all = Converter.allClasses();
        Arrays.sort(all);
        for (Object cl : all) {
            if (!((ClassInfo)cl).isPublic() || ((ClassInfo)cl).isHidden()) continue;
            Doclava.cantStripThis((ClassInfo)cl, notStrippable);
        }
        PrintStream stream = null;
        try {
            stream = new PrintStream(filename);
            for (ClassInfo cl : notStrippable) {
                stream.println(Doclava.getPrintableName(cl));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("error writing file: " + filename);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static PackageInfo[] choosePackages() {
        if (sVisiblePackages != null) {
            return sVisiblePackages;
        }
        ClassInfo[] classes = Converter.rootClasses();
        TreeMap<String, PackageInfo> sorted = new TreeMap<String, PackageInfo>();
        for (ClassInfo cl : classes) {
            PackageInfo pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (String s : sorted.keySet()) {
            PackageInfo pkg = (PackageInfo)sorted.get(s);
            if (pkg.isHidden()) continue;
            Boolean allHidden = true;
            ClassInfo[] classesToCheck = null;
            for (int pass = 0; pass < 5; ++pass) {
                switch (pass) {
                    case 0: {
                        classesToCheck = pkg.ordinaryClasses();
                        break;
                    }
                    case 1: {
                        classesToCheck = pkg.enums();
                        break;
                    }
                    case 2: {
                        classesToCheck = pkg.errors();
                        break;
                    }
                    case 3: {
                        classesToCheck = pkg.exceptions();
                        break;
                    }
                    case 4: {
                        classesToCheck = pkg.getInterfaces();
                        break;
                    }
                    default: {
                        System.err.println("Error reading package: " + pkg.name());
                    }
                }
                for (ClassInfo cl : classesToCheck) {
                    if (cl.isHidden()) continue;
                    allHidden = false;
                    break;
                }
                if (!allHidden.booleanValue()) break;
            }
            if (allHidden.booleanValue()) continue;
            result.add(pkg);
        }
        sVisiblePackages = result.toArray(new PackageInfo[result.size()]);
        return sVisiblePackages;
    }

    public static PackageInfo[] chooseModulePackages() {
        ClassInfo[] classes = Converter.rootClasses();
        TreeMap<String, PackageInfo> sorted = new TreeMap<String, PackageInfo>();
        for (ClassInfo cl : classes) {
            if (!cl.isModule()) continue;
            PackageInfo pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (String s : sorted.keySet()) {
            PackageInfo pkg = (PackageInfo)sorted.get(s);
            result.add(pkg);
        }
        return result.toArray(new PackageInfo[result.size()]);
    }

    public static void writePackages(String filename) {
        Data data = Doclava.makePackageHDF();
        int i = 0;
        for (PackageInfo pkg : Doclava.choosePackages()) {
            Doclava.writePackage(pkg);
            data.setValue("docs.packages." + i + ".name", pkg.name());
            data.setValue("docs.packages." + i + ".link", pkg.htmlPage());
            TagInfo.makeHDF(data, "docs.packages." + i + ".shortDescr", pkg.firstSentenceTags());
            ++i;
        }
        Doclava.setPageTitle(data, "Package Index");
        TagInfo.makeHDF(data, "root.descr", Converter.convertTags(root.inlineTags(), null));
        ClearPage.write(data, "packages.cs", filename);
        ClearPage.write(data, "package-list.cs", "java/package-list");
        Proofread.writePackages(filename, Converter.convertTags(root.inlineTags(), null));
    }

    public static void writeMarkdowns() {
        MarkdownProcessor markdown = new MarkdownProcessor();
        for (String[] m : mMarkdown) {
            try {
                String mdContent = FileUtils.readFileToString((File)new File(m[1]));
                String htmlContent = markdown.markdown(mdContent);
                String outFile = FilenameUtils.getName((String)m[1]).replaceAll(".md", ".html").toLowerCase();
                Data data = Doclava.makeHDF();
                data.setValue("content", htmlContent);
                data.setValue("section", m[0]);
                ClearPage.write(data, "markdown.cs", outFile);
            }
            catch (IOException e) {
                System.err.println("Cannot read " + m[1] + " file: " + e.getMessage());
            }
        }
    }

    public static void writeModules(String filename) {
        Data data = Doclava.makeHDF();
        int i = 0;
        for (PackageInfo pkg : Doclava.chooseModulePackages()) {
            data.setValue("reference", "1");
            data.setValue("reference.apilevels", sinceTagger.hasVersions() ? "1" : "0");
            data.setValue("docs.packages." + i + ".name", pkg.name());
            Doclava.makeModuleListHDF(data, "docs.packages." + i + ".modules", pkg.modules());
            for (int j = 0; j < pkg.modules().length; ++j) {
                Data classData = Doclava.makeHDF();
                ClassInfo mod = pkg.modules()[j];
                Doclava.writeModule(mod, classData);
            }
            ++i;
        }
        Doclava.setPageTitle(data, "Module Index");
        TagInfo.makeHDF(data, "root.descr", Converter.convertTags(root.inlineTags(), null));
        ClearPage.write(data, "modules.cs", filename);
        Proofread.writePackages(filename, Converter.convertTags(root.inlineTags(), null));
    }

    public static void writeModule(ClassInfo cl, Data data) {
        cl.makeHDF(data);
        Doclava.setPageTitle(data, cl.name());
        ClearPage.write(data, "module.cs", muleXmlDir + cl.modulePath());
        ClearPage.write(data, "schema.cs", muleXmlDir + cl.moduleSchemaPath());
    }

    public static void writePackage(PackageInfo pkg) {
        Data data = Doclava.makePackageHDF();
        String name = pkg.name();
        data.setValue("package.name", name);
        data.setValue("package.since.key", SinceTagger.keyForName(pkg.getSince()));
        data.setValue("package.since.name", pkg.getSince());
        data.setValue("package.descr", "...description...");
        pkg.setFederatedReferences(data, "package");
        Doclava.makeClassListHDF(data, "package.annotations", ClassInfo.sortByName(pkg.getAnnotations()));
        Doclava.makeClassListHDF(data, "package.interfaces", ClassInfo.sortByName(pkg.getInterfaces()));
        Doclava.makeClassListHDF(data, "package.classes", ClassInfo.sortByName(pkg.ordinaryClasses()));
        Doclava.makeClassListHDF(data, "package.modules", ClassInfo.sortByName(pkg.modules()));
        Doclava.makeClassListHDF(data, "package.enums", ClassInfo.sortByName(pkg.enums()));
        Doclava.makeClassListHDF(data, "package.exceptions", ClassInfo.sortByName(pkg.exceptions()));
        Doclava.makeClassListHDF(data, "package.errors", ClassInfo.sortByName(pkg.errors()));
        TagInfo[] shortDescrTags = pkg.firstSentenceTags();
        TagInfo[] longDescrTags = pkg.inlineTags();
        TagInfo.makeHDF(data, "package.shortDescr", shortDescrTags);
        TagInfo.makeHDF(data, "package.descr", longDescrTags);
        data.setValue("package.hasLongDescr", TagInfo.tagsEqual(shortDescrTags, longDescrTags) ? "0" : "1");
        String filename = javadocDir + pkg.relativePath();
        Doclava.setPageTitle(data, name);
        ClearPage.write(data, "package.cs", filename);
        filename = javadocDir + pkg.fullDescriptionFile();
        Doclava.setPageTitle(data, name + " Details");
        ClearPage.write(data, "package-descr.cs", filename);
        Proofread.writePackage(filename, pkg.inlineTags());
    }

    public static void writeClassLists() {
        String s;
        int i;
        Data data = Doclava.makePackageHDF();
        ClassInfo[] classes = PackageInfo.filterHidden(Converter.convertClasses(root.classes()));
        if (classes.length == 0) {
            return;
        }
        Object[] sorted = new Sorter[classes.length];
        for (i = 0; i < sorted.length; ++i) {
            ClassInfo cl = classes[i];
            String name = cl.name();
            sorted[i] = new Sorter(name, cl);
        }
        Arrays.sort(sorted);
        int firstMatch = 0;
        String lastName = ((Sorter)sorted[0]).label;
        for (i = 1; i < sorted.length; ++i) {
            s = ((Sorter)sorted[i]).label;
            if (lastName.equals(s)) continue;
            if (firstMatch != i - 1) {
                for (int j = firstMatch; j < i; ++j) {
                    PackageInfo pkg = ((ClassInfo)((Sorter)sorted[j]).data).containingPackage();
                    if (pkg == null) continue;
                    ((Sorter)sorted[j]).label = ((Sorter)sorted[j]).label + " (" + pkg.name() + ")";
                }
            }
            firstMatch = i;
            lastName = s;
        }
        Arrays.sort(sorted);
        for (i = 0; i < sorted.length; ++i) {
            s = ((Sorter)sorted[i]).label;
            ClassInfo cl = (ClassInfo)((Sorter)sorted[i]).data;
            char first = Character.toUpperCase(s.charAt(0));
            cl.makeShortDescrHDF(data, "docs.classes." + first + '.' + i);
        }
        Doclava.setPageTitle(data, "Class Index");
        ClearPage.write(data, "classes.cs", "java/classes" + htmlExtension);
    }

    public static void writeHierarchy() {
        ClassInfo[] classes = Converter.rootClasses();
        ArrayList<ClassInfo> info = new ArrayList<ClassInfo>();
        for (ClassInfo cl : classes) {
            if (cl.isHidden()) continue;
            info.add(cl);
        }
        Data data = Doclava.makePackageHDF();
        Hierarchy.makeHierarchy(data, info.toArray(new ClassInfo[info.size()]));
        Doclava.setPageTitle(data, "Class Hierarchy");
        ClearPage.write(data, "hierarchy.cs", "java/hierarchy" + htmlExtension);
    }

    public static void writeClasses() {
        ClassInfo[] classes = Converter.rootClasses();
        if (generateSources) {
            mHDFData.add(new String[]{"doclava.generate.sources", "true"});
            for (ClassInfo cl : classes) {
                Data data = Doclava.makePackageHDF();
                if (cl.isHidden()) continue;
                Doclava.writeSource(cl, data);
                Doclava.writeClass(cl, data);
            }
        } else {
            for (ClassInfo cl : classes) {
                Data data = Doclava.makePackageHDF();
                if (cl.isHidden()) continue;
                Doclava.writeClass(cl, data);
            }
        }
    }

    public static void writeClass(ClassInfo cl, Data data) {
        cl.makeHDF(data);
        Doclava.setPageTitle(data, cl.name());
        ClearPage.write(data, "class.cs", javadocDir + cl.relativePath());
        Proofread.writeClass(cl.htmlPage(), cl);
    }

    public static void writeSource(ClassInfo cl, Data data) {
        try {
            cl.makeHDF(data);
            data.setValue("class.source", SampleTagInfo.escapeHtml(cl.getSource()));
            Doclava.setPageTitle(data, cl.name());
            ClearPage.write(data, "source.cs", javadocDir + cl.relativePath("-source"));
        }
        catch (IOException e) {
            Errors.error(Errors.IO_ERROR, null, "Could not find source file for " + cl.name());
        }
    }

    public static void makeClassListHDF(Data data, String base, ClassInfo[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            ClassInfo cl = classes[i];
            if (cl.isHidden()) continue;
            cl.makeShortDescrHDF(data, base + "." + i);
        }
    }

    public static void makeModuleListHDF(Data data, String base, ClassInfo[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            ClassInfo cl = classes[i];
            if (cl.isHidden()) continue;
            cl.makeModuleShortDescrHDF(data, base + "." + i);
        }
    }

    public static String linkTarget(String source, String target) {
        int same;
        String[] src = source.split("/");
        String[] tgt = target.split("/");
        int srclen = src.length;
        int tgtlen = tgt.length;
        for (same = 0; same < srclen - 1 && same < tgtlen - 1 && src[same].equals(tgt[same]); ++same) {
        }
        String s = "";
        int up = srclen - same - 1;
        for (int i = 0; i < up; ++i) {
            s = s + "../";
        }
        int N = tgtlen - 1;
        for (int i = same; i < N; ++i) {
            s = s + tgt[i] + '/';
        }
        s = s + tgt[tgtlen - 1];
        return s;
    }

    private static boolean hasHideAnnotation(Doc doc) {
        String comment = doc.getRawCommentText();
        return comment.indexOf("@hide") != -1 || comment.indexOf("@pending") != -1;
    }

    private static boolean isHidden(Doc doc) {
        if (doc instanceof MemberDoc) {
            return Doclava.hasHideAnnotation(doc);
        }
        if (doc instanceof ClassDoc) {
            ClassDoc classDoc = (ClassDoc)doc;
            if (Doclava.hasHideAnnotation((Doc)classDoc.containingPackage())) {
                return true;
            }
            ClassDoc current = classDoc;
            do {
                if (!Doclava.hasHideAnnotation((Doc)current)) continue;
                return true;
            } while ((current = current.containingClass()) != null);
        }
        return false;
    }

    private static Object filterHidden(Object o, Class<?> expected) {
        if (o == null) {
            return null;
        }
        Class<?> type = o.getClass();
        if (type.getName().startsWith("com.sun.")) {
            return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)new HideHandler(o));
        }
        if (o instanceof Object[]) {
            Class<?> componentType = expected.getComponentType();
            Object[] array = (Object[])o;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (Object entry : array) {
                if (entry instanceof Doc && Doclava.isHidden((Doc)entry)) continue;
                list.add(Doclava.filterHidden(entry, componentType));
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        return o;
    }

    static String ensureSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    static {
        mHDFData = new ArrayList();
        mMarkdown = new ArrayList();
        escapeChars = new HashMap<Character, String>();
        title = "";
        sinceTagger = new SinceTagger();
        knownTags = new HashSet();
        federationTagger = new FederationTagger();
        generateDocs = true;
        generateSources = false;
        parseComments = false;
        apiVersion = null;
        jSilver = null;
        sVisiblePackages = null;
    }

    private static class HideHandler
    implements InvocationHandler {
        private final Object target;

        public HideHandler(Object target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (args != null && (methodName.equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
                args[0] = HideHandler.unwrap(args[0]);
            }
            if (methodName.equals("getRawCommentText")) {
                return this.filterComment((String)method.invoke(this.target, args));
            }
            if (proxy instanceof Type && methodName.equals("toString")) {
                return ((String)method.invoke(this.target, args)).replace("&", "&amp;");
            }
            try {
                return Doclava.filterHidden(method.invoke(this.target, args), method.getReturnType());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private String filterComment(String s) {
            if (s == null) {
                return null;
            }
            s = s.trim();
            while (s.length() >= 5 && s.charAt(s.length() - 5) == '{') {
                s = s + "&nbsp;";
            }
            return s;
        }

        private static Object unwrap(Object proxy) {
            if (proxy instanceof Proxy) {
                return ((HideHandler)Proxy.getInvocationHandler((Object)proxy)).target;
            }
            return proxy;
        }
    }
}

