<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========= OAUTH DETAIL ======== -->
<h2>OAuth</h2>
<p>This connector uses OAuth as an authorization and authentication mechanism. All the message processors or sources that require the connector
to be authorized by the service provider will throw a NotAuthorizedException until the connector is authorized properly.</p>
<p>Authorizing the connector is a simple process of calling:</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:authorize/&gt;
</pre>
<p>The call to authorize message processor must be made from a message coming from an HTTP inbound endpoint as the authorize process will
reply with a redirect to the service provider. The following is an example of how to use it in a flow with an HTTP inbound endpoint:</p>
<pre>
    &lt;flow name="authorizationAndAuthenticationFlow"&gt;
        &lt;http:inbound-endpoint host="localhost" port="8080" path="oauth-authorize"/&gt;
        &lt;<?cs var:class.moduleName ?>:authorize/&gt;
    &lt;/flow&gt;
</pre>
<p>If you hit that endpoint via a web-browser it will initiate the OAuth dance, redirecting the user to the service provider page
and creating a callback endpoint so the service provider can call us back once the user has been authenticated. Once the callback
gets called then the connector will switch to an authorized state and any message processor or source that requires authentication
can be called.</p>
<p>The authorize message processor supports the following attributes:</p>
<table id="lconfig" class="jd-sumtable">
<tr><th colspan="12">Authorize Attributes</th></tr>
<tr><th>Name</th><th>Default Value</th><th>Description</th></tr>
<?cs set:count = #2 ?>
    <?cs each:connectionAttribute=class.moduleOAuthAuthorizationParameters ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr><?cs var:connectionAttribute.name ?></nobr></td>
          <td class="jd-descrcol"><nobr><?cs var:connectionAttribute.defaultValue ?></nobr></td>
          <td class="jd-descrcol" width="100%"><?cs if:connectionAttribute.optional=="true" ?><i>Optional.&nbsp;</i><?cs /if ?><?cs call:op_tag_list(connectionAttribute.comment) ?></td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /each ?>

    <?cs if:class.moduleOAuth1Aware=="true" ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>authorizationUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAuthorizationUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>accessTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAccessTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider to obtain an access token</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>requestTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthRequestTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider used to obtain an un-authorized request token</td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /if ?>
    <?cs if:class.moduleOAuth2Aware=="true" ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>authorizationUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAuthorizationUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>accessTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAccessTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider to obtain an access token</td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /if ?>

</table>
<h3>After Authorization</h3>
<p>The <i>authorize</i> message processor is an intercepting one. If the connector is not authorized yet, it will with a redirect
to the service provider so the user can authorize the connector. This is the reason as to why the authorize needs to be behind
and <i>http:inbound-endpoint</i>. The service provider upon successful authentication and authorization then will call back the
connector. The connector will extract information from that call, set its internal state to authorized, and then continue
execution. When we say continue execution we mean executing everything that was after the authorize whose execution got
interrupted because the connector was not authorized.</p>
<pre>
  &lt;flow name="authorizationAndAuthenticationFlow"&gt;
      &lt;http:inbound-endpoint host="localhost" port="8080" path="oauth-authorize"/&gt;
      &lt;<?cs var:class.moduleName ?>:authorize/&gt;
      &lt;http:response-builder status="200"&gt;
          &lt;set-payload value="You have successfully authorized the connector"/&gt;
      &lt;/http:response-builder&gt;
  &lt;/flow&gt;
</pre>
<p>In the previous example we added the <i>http:response-build</i> (notice that this element is available only in Mule 3.3.0 and later). If
the connector is not authorized, the execution of the response builder will be delayed up to the point of the callback execution.</p>
<p>On the other hand if the connector has been authorized and you call <i>authorize</i> again then the flow execution will not stop, it will
rather continue and the <i>http:response-builder</i> will get executed right away rather than after the callback.</p>
<h3>Error Handling during Authorization</h3>
<p>If for any reason, an errors ocurrs while processing the callback, the exception strategy of the flow containing the authorize will be
executed. So, if the callback sent the wrong information you can handle that situation by setting up an exception strategy as follows:</p>
<pre>
  &lt;flow name="authorizationAndAuthenticationFlow"&gt;
      &lt;http:inbound-endpoint host="localhost" port="8080" path="oauth-authorize"/&gt;
      &lt;<?cs var:class.moduleName ?>:authorize/&gt;
      &lt;http:response-builder status="200"&gt;
          &lt;set-payload value="You have successfully authorized the connector"/&gt;
      &lt;/http:response-builder&gt;
      &lt;catch-exception-strategy&gt;
         &lt;http:response-builder status="404"&gt;
             &lt;set-payload value="An error has occurred authorizing the connector"/&gt;
         &lt;/http:response-builder&gt;
      &lt;/catch-exception-strategy&gt;
  &lt;/flow&gt;
</pre>
<h3>Unauthorize</h3>
<p>Once this connector has been authorized further calls to the <i>authorize</i> message processor will be no-ops. If you wish to reset
the state of the connector back to a non-authorized state you can call:</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:unauthorize/&gt;
</pre>
<p>Keep in mind that after the connector is unauthorized all future calls that attempt to access protected resources will fail until
 the connector is re-authorized.</p>
<h3>Callback Customization</h3>
<p>As mentioned earlier once authorize gets called and before we redirect the user to the service provider we create a callback
endpoint. The callback endpoint will get called automatically by the service provider once the user is authenticated and he
grants authorization to the connector to access his private information.</p>
<p>The callback can be customized in the config element of the this connector as follows:</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:config&gt;
        &lt;<?cs var:class.moduleName ?>:oauth-callback-config domain="${fullDomain}" localPort="${http.port}" remotePort="80"/&gt;
    &lt;/<?cs var:class.moduleName ?>:config&gt;
</pre>
<p>The <i>oauth-callback-config</i> element can be used to customize the endpoint that gets created for the callback. It
features the following attributes:</p>
<table id="lconfig" class="jd-sumtable">
<tr><th colspan="12">OAuth Callback Config Attributes</th></tr>
<tr><th>Name</th><th>Description</th></tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>connector-ref</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>Reference to a user-defined HTTP connector.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>domain</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The domain portion of the callback URL. This is usually something like xxx.cloudhub.io if you are deploying to CloudHub for example.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>localPort</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The local port number that the endpoint will listen on. Normally 80, in the case of CloudHub you can use the environment variable ${http.port}.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>remotePort</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>This is the port number that we will tell the service provider we are listening on. It is usually the same as localPort but it is separated in case your deployment features port forwarding or a proxy.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>path</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>Path under which the callback should be exposed. If not specified a random path will be generated.</td>
</tr>
</table>
<p class="caution">The example shown above is what the configuration would look like if your app would be deployed to CloudHub.</p>
<h3>Saving and Restoring State</h3>
<p>Once the service providers hits the callback it will do so in way that state information it is also sent. This state information
is later used by the connector on each call made to the service provider to let him know that we have completed the authorization
and authentication process.<p>
<p>The state information is currently held in-memory but the connector offers hooks to save/restore this state. The ammount of information
that needs to be saved and/or restored varies between version of the OAuth specification. At the bare minimum for OAuth 1.0a that needs
to be the OAuth access token and OAuth access token secret.</p>
<p>The following is an example of how to log the access token and access token secret.<p>
<pre>
    &lt;<?cs var:class.moduleName ?>:config&gt;
        &lt;<?cs var:class.moduleName ?>:oauth-save-access-token&gt;
            <?cs if:class.moduleOAuth1Aware=="true"?>&lt;logger level="INFO" message="Received access token #[variable:OAuthAccessToken] and #[variable:OAuthAccessTokenSecret]"/&gt;<?cs else ?>&lt;logger level="INFO" message="Received access token #[variable:OAuthAccessToken]"/&gt;<?cs /if ?>
        &lt;/<?cs var:class.moduleName ?>:oauth-save-access-token&gt;
    &lt;/<?cs var:class.moduleName ?>:config&gt;
</pre>
<p>The <i>oauth-save-access-token</i> is a message processor chain and you can add inside of it as many message processors as you want. The chain will
be called with special inbound properties in the message which the information that needs saved.</p>
<p>Restoring the information is equally simple:</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:config&gt;
        &lt;<?cs var:class.moduleName ?>:oauth-restore-access-token&gt;
            &lt;message-properties-transformer scope="invocation"&gt;
                &lt;add-message-property key="OAuthAccessToken" value="123"/&gt;<?cs if:class.moduleOAuth1Aware=="true"?>
                &lt;add-message-property key="OAuthAccessTokenSecret" value="567"/&gt;<?cs /if ?>
            &lt;/message-properties-transformer&gt;
        &lt;/<?cs var:class.moduleName ?>:oauth-restore-access-token&gt;
    &lt;/<?cs var:class.moduleName ?>:config&gt;
</pre>
<p>The example above does not do anything useful expect hardcode the access token and the token secret to 123 and 567 respectively. Just like
<i>oauth-save-access-token</i>, <i>oauth-restore-access-token</i> is another message processor chain. Once the chain is done executing
we will extract the OAuth access token property and OAuth access token secret property values.</p>
<p>The following shows a full example on how to save and restore using Mule ObjectStore Module to store the information inside an object store.<p>
<pre>
&lt;mule xmlns="http://www.mulesoft.org/schema/mule/core"
      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
      xmlns:<?cs var:class.moduleName ?>="<?cs var:class.moduleNamespace ?>"
      xmlns:objectstore="http://www.mulesoft.org/schema/mule/objectstore"
      xsi:schemaLocation="
               http://www.mulesoft.org/schema/mule/core
               http://www.mulesoft.org/schema/mule/core/current/mule.xsd
               http://www.mulesoft.org/schema/mule/objectstore
               http://www.mulesoft.org/schema/mule/objectstore/1.0/mule-objectstore.xsd
               <?cs var:class.moduleNamespace ?>
               <?cs var:class.moduleSchemaLocation ?>"&gt;

    &lt;<?cs var:class.moduleName ?>:config&gt;
        &lt;<?cs var:class.moduleName ?>:oauth-save-access-token&gt;
            &lt;objectstore:store key="OAuthAccessToken" value-ref="#[variable:OAuthAccessToken]"/&gt;
            &lt;objectstore:store key="OAuthAccessTokenSecret" value-ref="#[variable:OAuthAccessTokenSecret]"/&gt;
        &lt;/<?cs var:class.moduleName ?>:oauth-save-access-token&gt;
        &lt;<?cs var:class.moduleName ?>:oauth-restore-access-token&gt;
            &lt;enricher target="#[header:OAuthAccessToken]"&gt;
                &lt;objectstore:retrieve key="OAuthAccessToken"/&gt;
            &lt;/enricher&gt;
            &lt;enricher target="#[header:OAuthAccessTokenSecret]"&gt;
                &lt;objectstore:retrieve key="OAuthAccessTokenSecret"/&gt;
            &lt;/enricher&gt;
        &lt;/<?cs var:class.moduleName ?>:oauth-restore-access-token&gt;
    &lt;/<?cs var:class.moduleName ?>:config&gt;

&lt;/mule&gt;
</pre>

