<?cs # A link to a package ?><?cs 
def:package_link(pkg) ?>
  <a href="<?cs var:toroot ?>java/<?cs var:pkg.link ?>"><?cs var:pkg.name ?></a><?cs
/def ?>

<?cs # A link to a module ?><?cs
def:module_link(mod) ?>
  <a href="<?cs var:toroot ?>mule/<?cs var:mod.link ?>"><?cs var:mod.name ?>:<?cs var:mod.configElementName ?></a><?cs
/def ?>

<?cs # A link to a type, or not if it's a primitive type
        link: whether to create a link at the top level, always creates links in
              recursive invocations.
        Expects the following fields:
            .name
            .link
            .isPrimitive
            .superBounds.N.(more links)   (... super ... & ...)
            .extendsBounds.N.(more links) (... extends ... & ...)
            .typeArguments.N.(more links) (< ... >)
?><?cs 
def:type_link_impl(type, link) ?><?cs 
  if:type.link && link=="true" ?><?cs
    if:type.federated ?><a href="<?cs var:type.link ?>"><?cs
      var:type.label ?></a><?cs 
    else ?><a href="<?cs var:toroot ?>java/<?cs var:type.link ?>"><?cs var:type.label ?></a><?cs
    /if ?><?cs
  else ?><?cs var:type.label ?><?cs
  /if ?><?cs if:subcount(type.extendsBounds) ?><?cs
      each:t=type.extendsBounds ?><?cs
          if:first(t) ?>&nbsp;extends&nbsp;<?cs else ?>&nbsp;&amp;&nbsp;<?cs /if ?><?cs
          call:type_link_impl(t, "true") ?><?cs
      /each ?><?cs
  /if ?><?cs
  if:subcount(type.superBounds) ?><?cs
      each:t=type.superBounds ?><?cs
          if:first(t) ?>&nbsp;super&nbsp;<?cs else ?>&nbsp;&amp;&nbsp;<?cs /if ?><?cs
          call:type_link_impl(t, "true") ?><?cs
      /each ?><?cs
  /if ?><?cs
  if:subcount(type.typeArguments)
      ?>&lt;<?cs each:t=type.typeArguments ?><?cs call:type_link_impl(t, "true") ?><?cs
          if:!last(t) ?>,&nbsp;<?cs /if ?><?cs
      /each ?>&gt;<?cs
  /if ?><?cs
/def ?>

<?cs def:class_name(type) ?><?cs call:type_link_impl(type, "false") ?><?cs /def ?>
<?cs def:type_link(type) ?><?cs call:type_link_impl(type, "true") ?><?cs /def ?>

<?cs # a conditional link.
      if the "condition" parameter evals to true then the link is displayed
      otherwise only the text is displayed
?><?cs
def:cond_link(text, root, path, condition) ?><?cs
  if:condition ?><a href="<?cs var:root ?><?cs var:path ?>"><?cs /if ?><?cs var:text ?><?cs if:condition ?></a><?cs /if ?><?cs
/def ?>

<?cs # a conditional link.
      if the "condition" parameter evals to true then the link is displayed
      otherwise only the text is displayed
?><?cs
def:link(text, root, path) ?><a href="<?cs var:root ?><?cs var:path ?>"><?cs var:text ?></a><?cs
/def ?>

<?cs # A comma separated parameter list ?><?cs 
def:parameter_list(params) ?><?cs
  each:param = params ?><?cs
      call:type_link(param.type)?> <?cs
      var:param.name ?><?cs
      if: name(param)!=subcount(params)-1?>, <?cs /if ?><?cs
  /each ?><?cs
/def ?>

<?cs # A comma separated parameter list ?><?cs
def:xml_attribute_list(params) ?><?cs
  each:param = params ?><?cs
      call:type_link(param.type)?> <?cs
      var:param.name ?><?cs
      if: name(param)!=subcount(params)-1?>, <?cs /if ?><?cs
  /each ?><?cs
/def ?>

<?cs # Print a list of tags (e.g. description text ?><?cs 
def:tag_list(tags) ?><?cs
  each:tag = tags ?><?cs
      if:tag.name == "Text" ?><?cs var:tag.text?><?cs
      elif:tag.kind == "@more" ?><p><?cs
      elif:tag.kind == "@see" ?><code><a href="<?cs
        if:tag.isLocal?><?cs var:toroot ?>java/<?cs /if ?><?cs
        var:tag.href ?>"><?cs var:tag.label ?></a></code><?cs
      elif:tag.kind == "@seeHref" ?><a href="<?cs var:tag.href ?>"><?cs var:tag.label ?></a><?cs
      elif:tag.kind == "@seeJustLabel" ?><?cs var:tag.label ?><?cs
      elif:tag.kind == "@code" ?><code><?cs var:tag.text ?></code><?cs
      elif:tag.name == "@sample.xml" ?><?cs
      elif:tag.name == "@sample.java" ?><h5 class="jd-tagtitle">Java Sample</h5><pre><?cs var:tag.text ?></pre><?cs
      elif:tag.name == "@include" ?><?cs var:tag.text ?><?cs
      elif:tag.kind == "@docRoot" ?><?cs var:toroot ?><?cs
      elif:tag.kind == "@inheritDoc" ?><?cs # This is the case when @inheritDoc is in something
                                              that doesn't inherit from anything?><?cs
      elif:tag.kind == "@attr" ?><?cs
      else ?>{<?cs var:tag.name?> <?cs var:tag.text ?>}<?cs
      /if ?><?cs
  /each ?><?cs
/def ?>

<?cs # Print a list of tags (e.g. description text ?><?cs
def:op_tag_list(tags) ?><?cs
  each:tag = tags ?><?cs
      if:tag.name == "Text" ?><?cs var:tag.text?><?cs
      elif:tag.kind == "@more" ?><p><?cs
      elif:tag.kind == "@see" ?><code><a href="<?cs
        if:tag.isLocal?><?cs var:toroot ?>java/<?cs /if ?><?cs
        var:tag.href ?>"><?cs var:tag.label ?></a></code><?cs
      elif:tag.kind == "@seeHref" ?><a href="<?cs var:tag.href ?>"><?cs var:tag.label ?></a><?cs
      elif:tag.kind == "@seeJustLabel" ?><?cs var:tag.label ?><?cs
      elif:tag.kind == "@code" ?><code><?cs var:tag.text ?></code><?cs
      elif:tag.name == "@sample.xml" ?><div class="jd-tagdata"><h5 class="jd-tagtitle">XML Sample</h5><pre><?cs var:tag.text ?></pre></div><?cs
      elif:tag.name == "@sample.java" ?><?cs
      elif:tag.name == "@sample.config" ?><?cs
      elif:tag.name == "@include" ?><?cs var:tag.text ?><?cs
      elif:tag.kind == "@docRoot" ?><?cs var:toroot ?><?cs
      elif:tag.kind == "@inheritDoc" ?><?cs # This is the case when @inheritDoc is in something
                                              that doesn't inherit from anything?><?cs
      elif:tag.kind == "@attr" ?><?cs
      else ?>{<?cs var:tag.name?> <?cs var:tag.text ?>}<?cs
      /if ?><?cs
  /each ?><?cs
/def ?>

<?cs # Print a list of tags (e.g. description text ?><?cs
def:sample_config(tags) ?><?cs
  each:tag = tags ?><?cs
      if:tag.name == "@sample.config" ?><div class="jd-tagdata"><h3>Example</h3><pre><?cs var:tag.text ?></pre></div>
    <?cs /if ?><?cs
  /each ?><?cs
/def ?>

<?cs # Print a list of tags (e.g. description text ?><?cs
def:op_tag_list_no_sample(tags) ?><?cs
  each:tag = tags ?><?cs
      if:tag.name == "Text" ?><?cs var:tag.text?><?cs
      elif:tag.kind == "@more" ?><p><?cs
      elif:tag.kind == "@see" ?><code><a href="<?cs
        if:tag.isLocal?><?cs var:toroot ?>java/<?cs /if ?><?cs
        var:tag.href ?>"><?cs var:tag.label ?></a></code><?cs
      elif:tag.kind == "@seeHref" ?><a href="<?cs var:tag.href ?>"><?cs var:tag.label ?></a><?cs
      elif:tag.kind == "@seeJustLabel" ?><?cs var:tag.label ?><?cs
      elif:tag.name == "@sample.xml" ?><?cs elif:tag.name == "@sample.java" ?><?cs elif:tag.name == "@include" ?><?cs var:tag.text ?><?cs
      elif:tag.kind == "@docRoot" ?><?cs var:toroot ?><?cs
      elif:tag.kind == "@inheritDoc" ?><?cs # This is the case when @inheritDoc is in something
                                              that doesn't inherit from anything?><?cs
      elif:tag.kind == "@attr" ?><?cs
      else ?>{<?cs var:tag.name?> <?cs var:tag.text ?>}<?cs
      /if ?><?cs
  /each ?><?cs
/def ?>

<?cs # The message about This xxx is deprecated. ?><?cs 
def:deprecated_text(kind) ?>
  This <?cs var:kind ?> is deprecated.<?cs 
/def ?>

<?cs # Show the short-form description of something.  These come from shortDescr and deprecated ?><?cs 
def:short_descr(obj) ?><?cs
  if:subcount(obj.deprecated) ?>
      <em><?cs call:deprecated_text(obj.kind) ?>
      <?cs call:tag_list(obj.deprecated) ?></em><?cs
  else ?><?cs call:tag_list(obj.shortDescr) ?><?cs
  /if ?><?cs
/def ?>

<?cs # Show the short-form description of something.  These come from shortDescr and deprecated ?><?cs
def:op_short_descr(obj) ?><?cs
  if:subcount(obj.deprecated) ?>
      <em><?cs call:deprecated_text(obj.kind) ?>
      <?cs call:op_tag_list_no_sample(obj.deprecated) ?></em><?cs
  else ?><?cs call:op_tag_list_no_sample(obj.shortDescr) ?><?cs
  /if ?><?cs
/def ?>

<?cs # Show the red box with the deprecated warning ?><?cs 
def:deprecated_warning(obj) ?><?cs 
  if:subcount(obj.deprecated) ?><p>
  <p class="caution">
      <strong><?cs call:deprecated_text(obj.kind) ?></strong><br/> <?cs 
      call:tag_list(obj.deprecated) ?>
  </p><?cs 
  /if ?><?cs 
/def ?>

<?cs # print the See Also: section ?><?cs 
def:see_also_tags(also) ?><?cs 
  if:subcount(also) ?>
  <div class="jd-tagdata">
      <h5 class="jd-tagtitle">See Also</h5>
      <ul class="nolist"><?cs 
        each:tag=also ?><li><?cs
            if:tag.kind == "@see" ?><code><a href="<?cs var:toroot ?><?cs var:tag.href ?>"><?cs
                    var:tag.label ?></a></code><?cs
            elif:tag.kind == "@seeHref" ?><a href="<?cs var:tag.href ?>"><?cs var:tag.label ?></a><?cs
            elif:tag.kind == "@seeJustLabel" ?><?cs var:tag.label ?><?cs
            else ?>[ERROR: Unknown @see kind]<?cs
            /if ?></li><?cs 
        /each ?>
      </ul>
  </div><?cs 
  /if ?>
<?cs /def ?>

<?cs # print the API Level ?><?cs
def:since_tags(obj) ?>
<?cs if:reference.apilevels ?>
  Since: <a href="<?cs var:toroot ?>guide/appendix/api-levels.html#level<?cs var:obj.since.key ?>">API Level <?cs var:obj.since.name ?></a>
<?cs /if ?>
<?cs /def ?>
<?cs def:federated_refs(obj) ?>
  <?cs if:subcount(obj.federated) ?>
    <div>
    Also: 
    <?cs each:federated=obj.federated ?>
      <a href="<?cs var:federated.url ?>"><?cs var:federated.name ?></a><?cs 
      if:!last(federated) ?>,<?cs /if ?>
    <?cs /each ?>
    </div>
  <?cs /if ?>
<?cs /def ?>
<?cs # Print the long-form description for something.
       Uses the following fields: deprecated descr seeAlso since ?><?cs
def:description(obj) ?><?cs 
  call:deprecated_warning(obj) ?>
  <div class="jd-tagdata jd-tagdescr"><p><?cs call:tag_list(obj.descr) ?></p></div><?cs
  if:subcount(obj.attrRefs) ?>
  <div class="jd-tagdata">
      <h5 class="jd-tagtitle">Related XML Attributes</h5>
      <ul class="nolist"><?cs 
        each:attr=obj.attrRefs ?>
            <li><a href="<?cs var:toroot ?><?cs var:attr.href ?>"><?cs var:attr.name ?></a></li><?cs 
        /each ?>
      </ul>
  </div><?cs 
  /if ?><?cs 
  if:subcount(obj.paramTags) ?>
  <div class="jd-tagdata">
      <h5 class="jd-tagtitle">Parameters</h5>
      <table class="jd-tagtable"><?cs 
      each:tag=obj.paramTags ?>
        <tr>
          <th><?cs if:tag.isTypeParameter ?>&lt;<?cs /if ?><?cs var:tag.name
                  ?><?cs if:tag.isTypeParameter ?>&gt;<?cs /if ?></td>
          <td><?cs call:tag_list(tag.comment) ?></td>
        </tr><?cs 
      /each ?>
      </table>
  </div><?cs 
  /if ?><?cs 
  if:subcount(obj.returns) ?>
  <div class="jd-tagdata">
      <h5 class="jd-tagtitle">Returns</h5>
      <ul class="nolist"><li><?cs call:tag_list(obj.returns) ?></li></ul>
  </div><?cs 
  /if ?><?cs 
  if:subcount(obj.throws) ?>
  <div class="jd-tagdata">
      <h5 class="jd-tagtitle">Throws</h5>
      <table class="jd-tagtable"><?cs 
      each:tag=obj.throws ?>  
        <tr>
            <th><?cs call:type_link(tag.type) ?></td>
            <td><?cs call:tag_list(tag.comment) ?></td>
        </tr><?cs 
      /each ?>
      </table>
  </div><?cs 
  /if ?><?cs 
  call:see_also_tags(obj.seeAlso) ?><?cs
/def ?>

<?cs # Print the long-form description for something.
       Uses the following fields: deprecated descr seeAlso since ?><?cs
def:op_description(obj) ?><?cs
  call:deprecated_warning(obj) ?>
  <div class="jd-tagdata jd-tagdescr"><p><?cs call:op_tag_list(obj.descr) ?></p></div>
  <div class="jd-tagdata">
      <h5 class="jd-tagtitle">Attributes</h5>

        <table id="lconfig" class="jd-sumtable">
        <tr><th>Name</th><th>Default Value</th><th>Description</th><th>Java Type</th><th>MIME Type</th><th>Encoding</th></tr>
        <tr>
          <td class="jd-linkcol"><nobr>config-ref</nobr></td>
          <td class="jd-descrcol"></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>Specify which configuration to use.</td>
          <td class="jd-descrcol"></td>
          <td class="jd-descrcol"></td>
          <td class="jd-descrcol"></td>
        </tr>
          <?cs set:count = #2 ?>
          <?cs each:attribute=obj.paramTags ?>
                <?cs if:((attribute.isNestedProcessor=="0") && (attribute.isCollection=="0"))?>
                    <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
                        <td class="jd-linkcol"><nobr><?cs var:attribute.attributeName ?></nobr></td>
                        <td class="jd-descrcol"><?cs var:attribute.defaultValue ?></td>
                        <td class="jd-descrcol"><?cs if:attribute.optional=="true" ?><i>Optional.&nbsp;</i><?cs /if ?><?cs call:op_tag_list(attribute.comment) ?></td>
                        <td class="jd-descrcol"><?cs if:attribute.useLinkForClass=="true" ?><?cs call:type_link(attribute.type)?><?cs else ?><?cs var:attribute.label ?><?cs /if ?></td>
                        <td class="jd-descrcol"><?cs var:attribute.mimeType ?></td>
                        <td class="jd-descrcol"><?cs var:attribute.encoding ?></td>
                    </tr>
                <?cs set:count = count + #1 ?>
                <?cs /if ?>
          <?cs /each ?>
          <?cs if:(obj.hasConnectionManager=="1") ?>
              <tr><th colspan="12">Connection Parameters<br/><span style="font-weight: 200;">This are only required if you didn't specified them at the configuration element. They are also useful for overriding the values of the configurations or even if you need to extract them from the Mule message since they support expression evaluation.</span></th></tr>
                <?cs each:attribute=obj.connectionTags ?>
                    <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
                        <td class="jd-linkcol"><nobr><?cs var:attribute.attributeName ?></nobr></td>
                        <td class="jd-descrcol"><?cs var:attribute.defaultValue ?></td>
                        <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i><?cs call:op_tag_list(attribute.comment) ?></td>
                        <td class="jd-descrcol"><?cs if:attribute.useLinkForClass=="true" ?><?cs call:type_link(attribute.type)?><?cs else ?><?cs var:attribute.label ?><?cs /if ?></td>
                        <td class="jd-descrcol"><?cs var:attribute.mimeType ?></td>
                        <td class="jd-descrcol"><?cs var:attribute.encoding ?></td>
                    </tr>
                    <?cs set:count = count + #1 ?>
                <?cs /each ?>
          <?cs /if ?>
          <?cs if:(obj.hasOAuthManager=="1") ?>
              <tr><th colspan="12">OAuth Parameters<br/><span style="font-weight: 200;">The following values are always required when using OAuth as the authentication mechanism.</span></th></tr>
                    <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
                        <td class="jd-linkcol"><nobr>accessTokenId</nobr></td>
                        <td class="jd-descrcol"></td>
                        <td class="jd-descrcol" width="100%">Access token identifier used to retrieve an access token from the store</td>
                        <td class="jd-descrcol"></td>
                        <td class="jd-descrcol"></td>
                        <td class="jd-descrcol"></td>
                    </tr>
          <?cs /if ?>
        </table>
  </div>
  <?cs if:obj.hasChildElements == "true" ?>
      <div class="jd-tagdata">
          <h5 class="jd-tagtitle">Child Elements</h5>
            <table id="lconfig" class="jd-sumtable">
              <?cs set:count = #2 ?>
              <tr><th>Name</th><th>Default Value</th><th>Description</th><th>Java Type</th></td>
              <?cs each:attribute=obj.paramTags ?>
                <?cs if:((attribute.isNestedProcessor=="1") || (attribute.isCollection=="1")) ?>
                    <tr>
                        <td><nobr>&lt;<?cs var:obj.moduleName ?>:<?cs var:attribute.attributeName ?>&gt;</nobr></td>
                        <td><?cs var:attribute.defaultValue ?></td>
                        <td><?cs if:attribute.optional=="true" ?><i>Optional.&nbsp;</i><?cs /if ?><?cs call:op_tag_list(attribute.comment) ?></td>
                        <td><?cs call:type_link(attribute.type)?></td>
                    </tr>
                <?cs set:count = count + #1 ?>
                <?cs /if ?>
              <?cs /each ?>
          </table>
      </div>
  <?cs /if ?>
  <?cs if:subcount(obj.returns) ?>
      <div class="jd-tagdata">
         <h5 class="jd-tagtitle">Returns</h5>
         <table id="lconfig" class="jd-sumtable">
             <tr>
                <th>Return Type</th>
                <th>Description</th>
             </tr>
             <tr>
                <td class="jd-descrcol"><?cs call:type_link(obj.returnPayload)?></td>
                <td class="jd-descrcol"><?cs call:op_tag_list(obj.returns) ?></td>
             </tr>
         </table>
  </div><?cs
  /if ?>
    <?cs if:subcount(obj.api) ?>
    <div class="jd-tagdata">
        <h5 class="jd-tagtitle">API Information</h5>
        <ul class="nolist"><li><?cs call:op_tag_list(obj.api) ?></li></ul>
    </div><?cs
    /if ?>
  <?cs
  if:subcount(obj.throws) ?>
  <div class="jd-tagdata">
      <h5 class="jd-tagtitle">Exception Payloads</h5>
      <table class="jd-sumtable">
        <tr><th>Payload Class</th><th>Description</th></tr>
        <?cs each:tag=obj.throws ?>
        <tr>
            <td><?cs call:type_link(tag.type) ?></td>
            <td><?cs call:op_tag_list(tag.comment) ?></td>
        </tr><?cs
      /each ?>
      </table>
  </div><?cs
  /if ?><?cs
  call:see_also_tags(obj.seeAlso) ?><?cs
/def ?>

<?cs # A table of links to classes with descriptions, as in a package file or the nested classes ?><?cs
def:class_link_table(classes) ?><?cs 
  set:count = #1 ?>
  <table class="jd-sumtable-expando"><?cs
      each:cl=classes ?>
        <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:cl.type.since.key ?>" >
              <td class="jd-linkcol"><?cs call:type_link(cl.type) ?></td>
              <td class="jd-descrcol" width="100%"><?cs call:short_descr(cl) ?>&nbsp;</td>
          </tr><?cs set:count = count + #1 ?><?cs
      /each ?>
  </table><?cs 
/def ?>

<?cs # A list of links to classes, for use in the side navigation of classes when viewing a package (panel nav) ?><?cs 
def:class_link_list(label, classes) ?><?cs 
  if:subcount(classes) ?>
    <li><h2><?cs var:label ?></h2>
      <ul><?cs 
      each:cl=classes ?>
        <li class="api apilevel-<?cs var:cl.type.since.key ?>"><?cs call:type_link(cl.type) ?></li><?cs 
      /each ?>
      </ul>
    </li><?cs 
  /if ?><?cs 
/def ?>

<?cs # A list of links to classes, for use in the side navigation of classes when viewing a class (panel nav) ?><?cs 
def:list(label, classes) ?><?cs 
  if:subcount(classes) ?>
    <li><h2><?cs var:label ?></h2>
      <ul><?cs 
      each:cl=classes ?>
          <li class="<?cs if:class.name == cl.label?>selected <?cs /if ?>api apilevel-<?cs var:cl.since.key ?>"><?cs call:type_link(cl) ?></li><?cs 
      /each ?>
      </ul>
    </li><?cs 
  /if ?><?cs 
/def ?>

<?cs # A list of links to packages, for use in the side navigation of packages (panel nav) ?><?cs 
def:package_link_list(packages) ?><?cs 
  each:pkg=packages ?>
    <li class="<?cs if:(class.package.name == pkg.name) || (package.name == pkg.name)?>selected <?cs /if ?>api apilevel-<?cs var:pkg.since.key ?>"><?cs call:package_link(pkg) ?></li><?cs 
  /each ?><?cs
/def ?>

<?cs # An expando trigger ?><?cs 
def:expando_trigger(id, default) ?>
  <a href="#" onclick="return toggleInherited(this, null)" id="<?cs var:id ?>" class="jd-expando-trigger closed"
          ><img id="<?cs var:id ?>-trigger"
          src="<?cs var:toassets ?>images/triangle-<?cs var:default ?>.png"
          class="jd-expando-trigger-img" /></a><?cs 
/def ?>

<?cs # An expandable list of classes ?><?cs 
def:expandable_class_list(id, classes, default) ?>
  <div id="<?cs var:id ?>">
      <div id="<?cs var:id ?>-list"
              class="jd-inheritedlinks"
              <?cs if:default != "list" ?>style="display: none;"<?cs /if ?>
              >
          <?cs if:subcount(classes) <= #20 ?>
            <?cs each:cl=classes ?>
              <?cs call:type_link(cl.type) ?><?cs if:!last(cl) ?>,<?cs /if ?>
            <?cs /each ?>
          <?cs else ?>
            <?cs set:leftovers = subcount(classes) - #15 ?>
            <?cs loop:i = #0, #14, #1 ?>
              <?cs with:cl=classes[i] ?>
                <?cs call:type_link(cl.type) ?>,
              <?cs /with ?>
              <?cs  if:(#i == #14) ?>and
                <a href="#" onclick="return toggleInherited(document.getElementById('<?cs
                   var:id ?>', null))"><?cs var:leftovers ?> others.</a>
              <?cs /if ?>
            <?cs /loop ?>
          <?cs /if ?>
      </div>
      <div id="<?cs var:id ?>-summary"
              <?cs if:default != "summary" ?>style="display: none;"<?cs /if ?>
              ><?cs 
          call:class_link_table(classes) ?>
      </div>
  </div><?cs 
/def ?>

<?cs include:"components.cs" ?>

