<?cs # this next line must be exactly like this to be parsed by eclipse ?>
<!-- ========= OAUTH2 DETAIL ======== -->
<h2>OAuth2</h2>
<p>This connector uses OAuth2 as an authorization and authentication mechanism with automatic saving and restoring
of access tokens. Every message processor in this connector keeps track of an attribute called <i>accessTokenId</i> which
 identifies each of the users that were authorized by the connector. In order to obtain an access token identification you need to
 first call the <i>authorize message processor</i>.</p>
<p>Authorizing the connector is a simple process of calling:</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:authorize/&gt;
</pre>
<p>The call to authorize the message processor must be made though a message coming from an HTTP inbound endpoint as the authorize process will
 reply with a redirect to the service provider. The following is an example of how to use it in a flow with an HTTP inbound endpoint:</p>
<pre>
    &lt;flow name="authorizationAndAuthenticationFlow"&gt;
        &lt;http:inbound-endpoint host="localhost" port="8080" path="oauth-authorize"/&gt;
        &lt;<?cs var:class.moduleName ?>:authorize/&gt;
    &lt;/flow&gt;
</pre>
<p>If you hit that endpoint via a web-browser it will initiate the OAuth dance, redirecting the user to the service provider page.
It will also create a callback endpoint so the service provider can redirect the user back once the user has been authenticated and properly authorized.
 Once the callback gets called the connector will automatically issue an access token identifier that will be stored in an ObjectStore.
 By default, this ObjectStore's OauthAccessTokenId will be the connector's config name.</p>
<p>The authorize message processor also supports the following attributes:</p>
<table id="lconfig" class="jd-sumtable">
<tr><th colspan="12">Authorize Attributes</th></tr>
<tr><th>Name</th><th>Default Value</th><th>Description</th></tr>
<?cs set:count = #2 ?>
    <?cs each:connectionAttribute=class.moduleOAuthAuthorizationParameters ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr><?cs var:connectionAttribute.name ?></nobr></td>
          <td class="jd-descrcol"><nobr><?cs var:connectionAttribute.defaultValue ?></nobr></td>
          <td class="jd-descrcol" width="100%"><?cs if:connectionAttribute.optional=="true" ?><i>Optional.&nbsp;</i><?cs /if ?><?cs call:op_tag_list(connectionAttribute.comment) ?></td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /each ?>

    <?cs if:class.moduleOAuth1Aware=="true" ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>authorizationUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAuthorizationUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>accessTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAccessTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider to obtain an access token</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>requestTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthRequestTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider used to obtain an un-authorized request token</td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /if ?>
    <?cs if:class.moduleOAuth2Aware=="true" ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>authorizationUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAuthorizationUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider where the resource owner will be redirected to grant authorization to the connector</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
          <td class="jd-linkcol"><nobr>accessTokenUrl</nobr></td>
          <td class="jd-descrcol"><?cs var:class.moduleOAuthAccessTokenUrl ?></td>
          <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The URL defined by the Service Provider to obtain an access token</td>
      </tr>
      <?cs set:count = count + #1 ?>
      <tr class="<?cs if:count % #2 ?>alt-color<?cs /if ?> api apilevel-<?cs var:field.since.key ?>" >
            <td class="jd-linkcol"><nobr>accessTokenId</nobr></td>
            <td class="jd-descrcol">&nbsp;</td>
            <td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The Id with which the obtained access token will be stored. If not provided, then it will be the config name</td>
      </tr>
      <?cs set:count = count + #1 ?>
    <?cs /if ?>

</table>

<p>When dealing with multi-tenant on-premise implementations, leaving the accessTokenId parameter in the authorize message processor to it's
default value could lead to token overwriting. This is not a problem when running on CloudHub, but can be a serious issue when running on-premise.
In these cases it is recommended to set the parameter to:</p>
<pre>
    &lt;google-calendars:authorize accessTokenId=&quot;#[flowVars['myTenantId']]&quot;/&gt;
</pre>
<p>If you do this, keep in mind that message processors will still be searching for the default OauthAccessTokenId unless told differently.
You must then overwrite this property on message processors as well:</p>
<pre>
    &lt;google-calendars:get-events accessTokenId=&quot;[flowVars['myTenantId']]&quot;/&gt;
</pre>

<h3>After Authorization</h3>
<p>The <i>authorize</i> message processor is an intercepting one. If something that requires authentication is requested but the connector
is not authorized yet, the authorize message processor will be triggered. It will redirect the user to the service provider so that he can authorize
the connector. This is why the authorize message processor needs to be behind an <i>http:inbound-endpoint</i>. Once authentication and authorization
are successful, the service provider will respond to the connector with a callback. The connector will extract information from this callback, set
its own internal state to authorized, and then move on to executing anything that had been interrupted by the authorization method.</p>
<pre>
  &lt;flow name="authorizationAndAuthenticationFlow"&gt;
      &lt;http:inbound-endpoint host="localhost" port="8080" path="oauth-authorize"/&gt;
      &lt;<?cs var:class.moduleName ?>:authorize/&gt;
      &lt;http:response-builder status="200"&gt;
          &lt;set-payload value="You have successfully authorized the connector"/&gt;
      &lt;/http:response-builder&gt;
  &lt;/flow&gt;
</pre>
<p>In the above example we added the <i>http:response-builder</i> (keep in mind that this element is available only in Mule 3.3.0 and later). If
the connector is not yet authorized, the execution of the response builder will be delayed until the callback is received.</p>
<p>On the other hand, if the connector had already been <i>authorized</i> before, then the flow execution will not be delayed; it will
continue and the <i>http:response-builder</i> will get executed right away rather than after the callback.</p>
<p>The following is an example of the authorize message processor, after running it will print the access token identifier to the log:</p>
<pre>
    &lt;flow name="authorizationAndAuthenticationFlow"&gt;
        &lt;http:inbound-endpoint host="localhost" port="8080" path="oauth-authorize"/&gt;
        &lt;<?cs var:class.moduleName ?>:authorize/&gt;
		&lt;log level="INFO" message="The connector has been properly authorized. The access token identifier is #[flowVars['OAuthAccessTokenId']]"/&gt;
    &lt;/flow&gt;
</pre>
<p>The <i>OAuthAccessTokenId</i> flow variable is stored into an ObjectStore by default. As an alternative, the following snippet shows how you can save it as a HTTP protocol cookie</p>
<pre>
    &lt;flow name="authorizationAndAuthenticationFlow"&gt;
        &lt;http:inbound-endpoint host="localhost" port="8080" path="oauth-authorize"/&gt;
        &lt;<?cs var:class.moduleName ?>:authorize/&gt;
        &lt;http:response-builder status="200"&gt;
            &lt;http:set-cookie name="accessTokenId" value="#[flowVars['OAuthAccessTokenId']]"/&gt;
            &lt;set-payload value="You have successfully authorized the connector. You access token id is #[flowVars['OAuthAccessTokenId']]"/&gt;
        &lt;/http:response-builder&gt;
    &lt;/flow&gt;
</pre>
<p>The access token identifier is unique per user and therefore the connector can be authorized for many users. If the user authorizes the connector
 twice it will have the same access token identifier both times.</p>
<h3>Error Handling during Authorization</h3>
<p>If for any reason, an error occurs while processing the callback, the exception strategy of the flow containing the authorize will be executed.
So, if the callback sent the wrong information you can handle that situation by setting up an exception strategy as follows:</p>
<pre>
  &lt;flow name="authorizationAndAuthenticationFlow"&gt;
      &lt;http:inbound-endpoint host="localhost" port="8080" path="oauth-authorize"/&gt;
      &lt;<?cs var:class.moduleName ?>:authorize/&gt;
      &lt;http:response-builder status="200"&gt;
          &lt;set-payload value="You have successfully authorized the connector"/&gt;
      &lt;/http:response-builder&gt;
      &lt;catch-exception-strategy&gt;
         &lt;http:response-builder status="404"&gt;
             &lt;set-payload value="An error has occurred authorizing the connector"/&gt;
         &lt;/http:response-builder&gt;
      &lt;/catch-exception-strategy&gt;
  &lt;/flow&gt;
</pre>
<p> What happens if a tenant who is not yet authorized wants to perform an OAuth protected operation? You can set this with the <b>onNoToken</b> property: </p>
<pre>
&lt;<?cs var:class.moduleName ?>:config name=&quot;<?cs var:class.moduleName ?>s&quot; consumerKey=&quot;${consumerKey}&quot; consumerSecret=&quot;${consumerSecret}&quot; onNoToken=&quot;[STOP_FLOW|EXCEPTION]&quot;&gt;
    &lt;<?cs var:class.moduleName ?>:oauth-callback-config connector-ref=&quot;${oauth.http.connector}&quot; domain=&quot;${oauth.url}&quot; localPort=&quot;${https.port}&quot; async=&quot;false&quot; path=&quot;oauth2callback&quot; /&gt;
&lt;/google-calendars:config-with-oauth&gt;
</pre>
<p>The <b>onNoToken</b> property can be set to two different values:</p>
<ul>
<li>STOP_FLOW: acts as a filter and kills the execution of the flow</li>
<li>EXCEPTION: throws an exception informing that the token is still not acquired</li>
</ul>
<p>Keep in mind that after the connector is unauthorized all future calls that attempt to access protected resources will fail until the connector is re-authorized.</p>
<h3>Unauthorize</h3>
<p>Once this connector has been authorized further calls to the <i>authorize</i> message processor will be no-ops.
If you wish to reset the state of the connector back to a non-authorized state you must call:</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:unauthorize/&gt;
</pre>
<p>Keep in mind that after the connector is unauthorized all future calls that attempt to access protected resources will fail until
 the connector is re-authorized.</p>
<h3>Callback Customization</h3>
<p>As mentioned earlier, once authorize gets called and before we redirect the user to the service provider, we create a callback endpoint.
The callback endpoint will get called automatically by the service provider once the user is authenticated and he grants authorization to
the connector to access his private information.</p>
<p>The callback can be customized in the config element of the this connector as follows:</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:config&gt;
        &lt;<?cs var:class.moduleName ?>:oauth-callback-config domain="${fullDomain}" localPort="${http.port}" remotePort="80"/&gt;
    &lt;/<?cs var:class.moduleName ?>:config&gt;
</pre>
<p>The <i>oauth-callback-config</i> element can be used to customize the endpoint that gets created for the callback. It
features the following attributes:</p>
<table id="lconfig" class="jd-sumtable">
<tr><th colspan="12">OAuth Callback Config Attributes</th></tr>
<tr><th>Name</th><th>Description</th></tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>connector-ref</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>Reference to a user-defined HTTP connector.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>domain</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The domain portion of the callback URL. This is usually something like xxx.cloudhub.io if you are deploying to CloudHub for example.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>localPort</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>The local port number that the endpoint will listen on. Normally 80, in the case of CloudHub you can use the environment variable ${http.port}.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>remotePort</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>This is the port number that we will tell the service provider we are listening on. It is usually the same as localPort but it is separated in case your deployment features port forwarding or a proxy.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>path</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>Path under which the callback should be exposed. If not specified a random path will be generated.</td>
</tr>
<tr class="api" >
<td class="jd-linkcol"><nobr>defaultAccessTokenId</nobr></td>
<td class="jd-descrcol" width="100%"><i>Optional.&nbsp;</i>A Mule Expression to use as access token id. If provided, this expression will be evaluated for all obtained access tokens and the result will be used as their id (except in the cases in which a specific acessTokenId was provided on the authorize processor</td>
</tr>
</table>
<p class="caution">The example shown above is what the configuration would look like if your app would be deployed to CloudHub.</p>
<h3>Access Token Store</h3>
<p>This connector has the capability of automatically saving and restoring access tokens. The connector will store in either the default user object store
or a user-defined one the acquired access tokens, refresh tokens, and any other pertinent information using the access token identifier as the key.</p>
<p>The object store can be configured as follows</p>
<pre>
    &lt;<?cs var:class.moduleName ?>:config&gt;
        &lt;<?cs var:class.moduleName ?>:oauth-store-config objectStore-ref="my-object-store"/&gt;
    &lt;/<?cs var:class.moduleName ?>:config&gt;
</pre>
<p>There is only a single attribute entitled <i>objectStore-ref</i> in the <i>oauth-store-config</i> element that allows the user to specify the name
of the object store that he wishes to use to save and restore access tokens.</p>