/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet;

import com.google.clearsilver.jsilver.data.Data;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.devkit.doclet.ClearPage;
import org.mule.devkit.doclet.Comment;
import org.mule.devkit.doclet.Doclava;
import org.mule.devkit.doclet.SourcePositionInfo;
import org.mule.devkit.doclet.TagInfo;
import org.mule.devkit.doclet.TocInfo;

public class DocFile {
    private static final Pattern LINE = Pattern.compile("(.*)[\r]?\n", 8);
    private static final Pattern PROP = Pattern.compile("([^=]+)=(.*)");

    public static String readFile(String filename) {
        try {
            int amt;
            File f = new File(filename);
            int length = (int)f.length();
            FileInputStream is = new FileInputStream(f);
            InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
            char[] buf = new char[length];
            int index = 0;
            while ((amt = reader.read(buf, index, length - index)) >= 1) {
                index += amt;
            }
            return new String(buf, 0, index);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getProperty(String docfile, String property) {
        String filedata = DocFile.readFile(docfile);
        Matcher lines = LINE.matcher(filedata);
        String line = null;
        while (lines.find()) {
            Matcher prop;
            line = lines.group(1);
            if (line.length() <= 0) continue;
            if (line.equals("@jd:body") || !(prop = PROP.matcher(line)).matches()) break;
            String key = prop.group(1);
            String value = prop.group(2);
            if (!key.equalsIgnoreCase(property)) continue;
            return value;
        }
        return null;
    }

    public static void writePage(Map<String, List<TocInfo>> toc, String docfile, String relative, String outfile) {
        Data hdf = Doclava.makeHDF();
        int i = 0;
        for (String topic : toc.keySet()) {
            hdf.setValue("topics." + i + ".title", topic == null ? "Root" : topic);
            int j = 0;
            for (TocInfo page : toc.get(topic)) {
                hdf.setValue("topics." + i + ".topics." + j + ".title", page.getTitle());
                hdf.setValue("topics." + i + ".topics." + j + ".link", "../" + page.getFilename());
                ++j;
            }
            ++i;
        }
        String filedata = DocFile.readFile(docfile);
        int start = -1;
        int lineno = 1;
        Matcher lines = LINE.matcher(filedata);
        String line = null;
        while (lines.find()) {
            line = lines.group(1);
            if (line.length() > 0) {
                if (line.equals("@jd:body")) {
                    start = lines.end();
                    break;
                }
                Matcher prop = PROP.matcher(line);
                if (!prop.matches()) break;
                String key = prop.group(1);
                String value = prop.group(2);
                hdf.setValue(key, value);
            }
            ++lineno;
        }
        if (start < 0) {
            System.err.println(docfile + ":" + lineno + ": error parsing docfile");
            if (line != null) {
                System.err.println(docfile + ":" + lineno + ":" + line);
            }
            System.exit(1);
        }
        String fromTemplate = hdf.getValue("template.which", "");
        String fromPage = hdf.getValue("page.onlyfortemplate", "");
        if (!"".equals(fromPage) && !fromTemplate.equals(fromPage)) {
            return;
        }
        String commentText = filedata.substring(start);
        Comment comment = new Comment(commentText, null, new SourcePositionInfo(docfile, lineno, 1));
        TagInfo[] tags = comment.tags();
        TagInfo.makeHDF(hdf, "root.descr", tags);
        hdf.setValue("commentText", commentText);
        ClearPage.write(hdf, "docpage.cs", outfile);
    }
}

